/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractFile2DataSourceCommand;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectFilter;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableCollection;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;

public class ApplyTableDataCommand
extends AbstractFile2DataSourceCommand<Table> {
    private SqlType sqlType = SqlType.MERGE_BY_PK;
    private Predicate<AbstractSchemaObject<?>> filter = new SchemaObjectFilter();

    @Override
    protected List<Table> getTarget(List<DbCommonObject<?>> totalObjects, Connection connection) {
        List target = CommonUtils.list();
        for (DbCommonObject<?> obj : totalObjects) {
            if (obj instanceof Catalog) {
                Catalog catalog = (Catalog)obj;
                for (Schema schema : catalog.getSchemas()) {
                    for (Table table : schema.getTables()) {
                        target.add(table);
                    }
                }
                continue;
            }
            if (obj instanceof Schema) {
                Schema schema = (Schema)obj;
                for (Table table : schema.getTables()) {
                    target.add(table);
                }
                continue;
            }
            if (obj instanceof TableCollection) {
                TableCollection tables = (TableCollection)obj;
                target.addAll(tables);
                continue;
            }
            if (!(obj instanceof Table)) continue;
            Table table = (Table)obj;
            target.add(table);
        }
        return target;
    }

    @Override
    protected List<Table> filter(List<Table> list) {
        List target = CommonUtils.list();
        for (Table obj : list) {
            if (!this.filter.test((AbstractSchemaObject<?>)obj)) continue;
            target.add(obj);
        }
        return target;
    }

    @Override
    protected List<Table> sort(List<Table> list) {
        if (this.getSqlType().getTableComparator() != null) {
            list = SchemaUtils.getNewSortedTableList(list, (Comparator)this.getSqlType().getTableComparator());
        }
        return list;
    }

    @Override
    protected void handle(Table obj, SqlFactoryRegistry sqlFactoryRegistry, Connection connection) throws Exception {
        SqlFactory sqlFactory = this.getSqlFactoryRegistry().getSqlFactory((DbCommonObject)obj, this.getSqlType());
        List operations = sqlFactory.createSql((DbCommonObject)obj);
        this.getSqlExecutor().execute((Collection)operations);
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    public Predicate<AbstractSchemaObject<?>> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<AbstractSchemaObject<?>> filter) {
        this.filter = filter;
    }
}

