/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public class GenerateSimpleSqlCommand
extends AbstractCommand {
    private DbCommonObject<?> target;
    private SqlFactoryRegistry sqlFactoryRegistry;
    private List<SqlOperation> sqlOperations = CommonUtils.list();
    private SqlType sqlType = SqlType.CREATE;
    private Options schemaOptions = null;

    @Override
    protected void doRun() {
        this.sqlOperations = CommonUtils.list();
        if (this.getTarget() instanceof DbObject) {
            DbObject target = (DbObject)this.getTarget();
            SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry((DbCommonObject<?>)target);
            if (this.getSchemaOptions() != null) {
                sqlFactoryRegistry.setOption(this.getSchemaOptions());
            }
            SqlFactory<? extends DbCommonObject<?>> sqlFactory = this.getSqlFactory(sqlFactoryRegistry, target);
            this.sqlOperations.addAll(sqlFactory.createSql((DbCommonObject)target));
        } else {
            DbObjectCollection targetCollection = (DbObjectCollection)this.getTarget();
            SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry((DbCommonObject<?>)targetCollection);
            if (this.getSchemaOptions() != null) {
                sqlFactoryRegistry.setOption(this.getSchemaOptions());
            }
            for (DbObject dbObject : targetCollection) {
                SqlFactory<? extends DbCommonObject<?>> sqlFactory = this.getSqlFactory(sqlFactoryRegistry, dbObject);
                this.sqlOperations.addAll(sqlFactory.createSql((DbCommonObject)dbObject));
            }
        }
    }

    private SqlFactoryRegistry getSqlFactoryRegistry(DbCommonObject<?> target) {
        SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry();
        if (sqlFactoryRegistry == null) {
            Dialect dialect = SchemaUtils.getDialect(target);
            return dialect.getSqlFactoryRegistry();
        }
        return sqlFactoryRegistry;
    }

    protected SqlFactory<? extends DbCommonObject<?>> getSqlFactory(SqlFactoryRegistry sqlFactoryRegistry, DbObject<?> target) {
        return sqlFactoryRegistry.getSqlFactory(target, this.getSqlType());
    }

    public SqlFactoryRegistry getSqlFactoryRegistry() {
        return this.sqlFactoryRegistry;
    }

    public void setSqlFactoryRegistry(SqlFactoryRegistry sqlFactoryRegistry) {
        this.sqlFactoryRegistry = sqlFactoryRegistry;
    }

    public DbCommonObject<?> getTarget() {
        return this.target;
    }

    public void setTarget(DbCommonObject<?> target) {
        this.target = target;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    public List<SqlOperation> getOperations() {
        return this.sqlOperations;
    }

    public Options getSchemaOptions() {
        return this.schemaOptions;
    }

    public void setSchemaOption(Options schemaOptions) {
        this.schemaOptions = schemaOptions;
    }
}

