/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractDbObjectCollection;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractPartition;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.ArgumentRoutine;
import com.sqlapp.data.schemas.Body;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.Partition;
import com.sqlapp.data.schemas.Partitioning;
import com.sqlapp.data.schemas.PartitioningType;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.SubPartition;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.ArrayDimensionProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.SpecificNameProperty;
import com.sqlapp.util.AbstractIterator;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.JsonConverter;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HtmlUtils {
    private static Base64.Encoder encoder = Base64.getUrlEncoder();
    private static JsonConverter jsonConverter = new JsonConverter();

    public static String objectFullName(Object obj) {
        return HtmlUtils.objectFullNameInternal(obj, true, ".");
    }

    public static String objectFullNameWithoutSchemaName(Object obj) {
        return HtmlUtils.objectFullNameInternal(obj, false, ".");
    }

    public static String objectFullPath(Object obj) {
        return HtmlUtils.objectFullNameInternal(obj, true, "_");
    }

    public static String attr(String key, String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        return key + "=\"" + value + "\"";
    }

    private static String objectFullNameInternal(Object obj, boolean withSchema, String separator) {
        Operator namedObject;
        if (obj instanceof String) {
            return (String)obj;
        }
        StringBuilder builder = new StringBuilder();
        if (obj instanceof Schema) {
            Schema schema = (Schema)obj;
            if (schema.getName() != null) {
                builder.append(schema.getName());
                return builder.toString();
            }
        } else {
            AbstractSchemaObject schemaObject;
            if (obj instanceof Column) {
                Column column = (Column)obj;
                if (withSchema && column.getSchemaName() != null) {
                    builder.append(column.getSchemaName());
                    builder.append(separator);
                }
                builder.append(column.getTableName());
                builder.append(separator);
                builder.append(column.getName());
                return builder.toString();
            }
            if (obj instanceof AbstractSchemaObject && withSchema && (schemaObject = (AbstractSchemaObject)obj).getSchemaName() != null) {
                builder.append(schemaObject.getSchemaName());
                builder.append(separator);
            }
        }
        if (obj instanceof Operator) {
            namedObject = (Operator)obj;
            builder.append(HtmlUtils.escapeOperator(namedObject.getName()));
        } else if (obj instanceof ArgumentRoutine) {
            namedObject = (ArgumentRoutine)obj;
            if (namedObject.getSpecificName() != null) {
                builder.append(HtmlUtils.escapeName(namedObject.getSpecificName()));
            } else {
                builder.append(HtmlUtils.escapeName(namedObject.getName()));
            }
        } else if (obj instanceof AbstractNamedObject) {
            namedObject = (AbstractNamedObject)obj;
            builder.append(HtmlUtils.escapeName(namedObject.getName()));
        }
        return builder.toString();
    }

    private static String escapeName(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(value.length());
        block3: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    builder.append('_');
                    continue block3;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    private static String escapeOperator(String value) {
        try {
            return new String(encoder.encode(value.getBytes("utf8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String escape(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return "binary.length=" + bytes.length;
        }
        if (obj.getClass().isArray() || obj instanceof Collection) {
            final StringBuilder builder = new StringBuilder();
            AbstractIterator<Object> itr = new AbstractIterator<Object>(){

                protected void handle(Object obj, int index) throws Exception {
                    if (index > 0) {
                        builder.append(" ");
                    }
                    builder.append(HtmlUtils.escapeInternal(obj.toString()));
                }
            };
            try {
                itr.execute(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return builder.toString();
        }
        return HtmlUtils.escapeInternal(obj.toString());
    }

    private static String escapeInternal(String text) {
        if (text == null) {
            return "";
        }
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder((int)((double)text.length() * 1.2));
        int size = text.codePointCount(0, text.length());
        for (int i = 0; i < size; ++i) {
            int codePoint = text.codePointAt(i);
            if (codePoint == 60) {
                builder.append("&lt;");
                continue;
            }
            if (codePoint == 38) {
                builder.append("&amp;");
                continue;
            }
            if (codePoint == 62) {
                builder.append("&gt;");
                continue;
            }
            if (codePoint == 34) {
                builder.append("&quot;");
                continue;
            }
            if (codePoint == 10) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            if (codePoint == 9) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            if (Character.isISOControl(codePoint)) continue;
            builder.appendCodePoint(codePoint);
        }
        return builder.toString();
    }

    public static String zeroToEmpty(Number obj) {
        if (obj == null) {
            return "";
        }
        Long val = (Long)Converters.getDefault().convertObject((Object)obj, Long.class);
        if (val == 0L) {
            return "";
        }
        return obj.toString();
    }

    public static String escapeHtml(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static String joinLines(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj == null) {
            return "";
        }
        final StringBuilder builder = new StringBuilder();
        AbstractIterator<String> itr = new AbstractIterator<String>(){

            protected void handle(String obj, int index) throws Exception {
                builder.append(obj);
                builder.append('\n');
            }
        };
        try {
            itr.execute(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    public static boolean isAssemblySource(String name) {
        if (name.endsWith(".cs")) {
            return true;
        }
        if (name.endsWith(".vb")) {
            return true;
        }
        return name.endsWith(".jsl");
    }

    public static String binaryToString(byte[] bytes, String encode) throws UnsupportedEncodingException {
        if (CommonUtils.isEmpty((Object)bytes)) {
            return "";
        }
        return new String(bytes, encode);
    }

    private static Map<String, Integer> countProperties(Object arg) {
        Collection list = (Collection)arg;
        IntegerLinkedHashMap countMap = new IntegerLinkedHashMap();
        for (Object obj : list) {
            if (!(obj instanceof DbObject)) continue;
            DbObject dbObject = (DbObject)DbObject.class.cast(obj);
            Map map = dbObject.toMap();
            map.forEach((k, v) -> {
                int val = HtmlUtils.getCount(countMap, k + "Count");
                countMap.put(k + "Count", val += HtmlUtils.countObject(v));
            });
        }
        HtmlUtils.countSpecificName(list, countMap);
        HtmlUtils.countArrayDimensionInfo(list, countMap);
        HtmlUtils.countSchemaName(list, countMap);
        return countMap;
    }

    public static Map<String, Integer> countBodyProperties(Collection<?> collection) {
        Collection list = collection.stream().filter(c -> c instanceof Body).map(c -> ((Body)c).getBody()).filter(c -> c != null).collect(Collectors.toList());
        IntegerLinkedHashMap countMap = new IntegerLinkedHashMap();
        for (Object obj : list) {
            if (!(obj instanceof DbObject)) continue;
            DbObject dbObject = (DbObject)DbObject.class.cast(obj);
            Map map = dbObject.toMap();
            map.forEach((k, v) -> {
                int val = HtmlUtils.getCount(countMap, k + "BodyCount");
                countMap.put(k + "BodyCount", val += HtmlUtils.countObject(v));
            });
        }
        HtmlUtils.countSpecificName("specificNameBodyCount", list, countMap);
        return countMap;
    }

    private static int getCount(Map<String, Integer> map, String key) {
        Integer val = map.get(key);
        if (val == null) {
            return 0;
        }
        return val;
    }

    private static int countObject(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                return 1;
            }
            return 0;
        }
        if (obj instanceof String) {
            if (!CommonUtils.isEmpty((CharSequence)((String)obj))) {
                return 1;
            }
            return 0;
        }
        if (obj instanceof Number) {
            Number num = (Number)Number.class.cast(obj);
            if (num.longValue() != 0L) {
                return 1;
            }
            return 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        return 1;
    }

    public static Map<String, Integer> getArrayDimensionInfo(Collection<?> list) {
        Map map = CommonUtils.linkedMap();
        HtmlUtils.countArrayDimensionInfo(list, map);
        return map;
    }

    private static void countSchemaName(Collection<?> list, Map<String, Integer> map) {
        String name = SchemaProperties.SCHEMA_NAME.getLabel() + "Count";
        map.remove(name);
        for (Object obj : list) {
            SchemaNameProperty props;
            if (!(obj instanceof SchemaNameProperty) || CommonUtils.isEmpty((CharSequence)(props = (SchemaNameProperty)SchemaNameProperty.class.cast(obj)).getSchemaName())) continue;
            int val = HtmlUtils.getCount(map, name);
            map.put(name, ++val);
        }
    }

    private static void countArrayDimensionInfo(Collection<?> list, Map<String, Integer> map) {
        String arrayDimensionCount = SchemaProperties.ARRAY_DIMENSION.getLabel() + "Count";
        map.remove(arrayDimensionCount);
        String arrayLowerBoundCount = SchemaProperties.ARRAY_DIMENSION_LOWER_BOUND + "Count";
        map.remove(arrayLowerBoundCount);
        String arrayUpperBoundCount = SchemaProperties.ARRAY_DIMENSION_UPPER_BOUND + "Count";
        map.remove(arrayUpperBoundCount);
        for (Object obj : list) {
            ArrayDimensionProperties props;
            if (!(obj instanceof ArrayDimensionProperties) || (props = (ArrayDimensionProperties)ArrayDimensionProperties.class.cast(obj)).getArrayDimension() <= 0) continue;
            String name = arrayDimensionCount;
            int val = HtmlUtils.getCount(map, name);
            map.put(name, ++val);
            if (props.getArrayDimensionLowerBound() > 0) {
                name = arrayLowerBoundCount;
                val = HtmlUtils.getCount(map, name);
                map.put(name, ++val);
            }
            if (props.getArrayDimensionLowerBound() <= 0) continue;
            name = arrayUpperBoundCount;
            val = HtmlUtils.getCount(map, name);
            map.put(name, ++val);
        }
    }

    private static void countSpecificName(Collection<?> c, Map<String, Integer> map) {
        String name = "specificNameCount";
        HtmlUtils.countSpecificName(name, c, map);
    }

    private static void countSpecificName(String name, Collection<?> c, Map<String, Integer> map) {
        map.remove(name);
        for (Object obj : c) {
            if (!(obj instanceof SpecificNameProperty)) continue;
            SpecificNameProperty props = (SpecificNameProperty)SpecificNameProperty.class.cast(obj);
            if (obj instanceof NameProperty) {
                NameProperty nameProps = (NameProperty)NameProperty.class.cast(obj);
                if (CommonUtils.eq((Object)props.getSpecificName(), (Object)nameProps.getName())) continue;
                int val = HtmlUtils.getCount(map, name);
                map.put(name, ++val);
                continue;
            }
            if (CommonUtils.isEmpty((CharSequence)props.getSpecificName())) continue;
            int val = HtmlUtils.getCount(map, name);
            map.put(name, ++val);
        }
    }

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        return jsonConverter.toJsonString(obj);
    }

    public static List<? extends AbstractPartition<?>> getSubPartitions(Object obj) {
        if (obj instanceof Partition) {
            return ((Partition)obj).getSubPartitions();
        }
        if (obj instanceof Partitioning) {
            return HtmlUtils.getSubPartitions((Partitioning)obj);
        }
        if (obj instanceof Collection) {
            return HtmlUtils.getSubPartitions((Collection)obj);
        }
        return null;
    }

    private static List<SubPartition> getSubPartitions(Collection<Partition> partitions) {
        List<SubPartition> result = partitions.stream().flatMap(p -> p.getSubPartitions().stream()).collect(Collectors.toList());
        return result;
    }

    public static ParametersContext analyzeAllProperties(List<?> list) {
        ParametersContext context = new ParametersContext();
        Map<String, Integer> map = HtmlUtils.countProperties(list);
        map.forEach((k, v) -> context.put(k, v));
        map = HtmlUtils.countBodyProperties(list);
        map.forEach((k, v) -> context.put(k, v));
        HtmlUtils.putContextParam((ISchemaProperty)SchemaProperties.SPECIFICS, list, context);
        HtmlUtils.putContextParam((ISchemaProperty)SchemaProperties.STATISTICS, list, context);
        HtmlUtils.putContextBodyParam((ISchemaProperty)SchemaProperties.SPECIFICS, list, context);
        HtmlUtils.putContextBodyParam((ISchemaProperty)SchemaProperties.STATISTICS, list, context);
        map = HtmlUtils.getArrayDimensionInfo(list);
        map.forEach((k, v) -> context.put(k, v));
        context.put("arrayDimensionSize", (Object)map.size());
        return context;
    }

    private static void putContextParam(ISchemaProperty prop, List<?> list, ParametersContext context) {
        context.put(prop.getLabel(), HtmlUtils.getMapValues(prop, c -> c, list));
    }

    private static void putContextBodyParam(ISchemaProperty prop, List<?> list, ParametersContext context) {
        context.put(prop.getLabel() + "Body", HtmlUtils.getMapValues(prop, c -> {
            if (c instanceof Body) {
                return ((Body)c).getBody();
            }
            return null;
        }, list));
    }

    private static Map<String, DbValueInfo> getMapValues(ISchemaProperty prop, Function<Object, Object> func, List<?> list) {
        SortedMap result = CommonUtils.treeMap();
        for (Object obj : list) {
            Object converted = func.apply(obj);
            if (converted == null || !prop.isInstanceof(converted)) continue;
            Map map = (Map)prop.getValue(converted);
            map.forEach((k, v) -> {
                DbValueInfo dbValueInfo = (DbValueInfo)result.get(k);
                if (dbValueInfo == null) {
                    dbValueInfo = new DbValueInfo();
                    result.put(k, dbValueInfo);
                }
                if (v != null) {
                    dbValueInfo.getValues().add((String)v);
                }
            });
        }
        return result;
    }

    public static String colspan(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Number) {
            int val = ((Number)obj).intValue();
            if (val <= 1) {
                return "";
            }
            return "colspan=\"" + val + "\"";
        }
        return "";
    }

    public static String rowspan(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Number) {
            int val = ((Number)obj).intValue();
            if (val <= 1) {
                return "";
            }
            return "rowspan=\"" + val + "\"";
        }
        return "";
    }

    public static String partitionRange(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Table) {
            Table table = (Table)Table.class.cast(obj);
            if (table.getPartitionParent() == null) {
                return "";
            }
            Table parentTable = table.getPartitionParent().getTable();
            if (parentTable.getPartitioning() == null) {
                return "";
            }
            String value = parentTable.getPartitioning().getPartitioningType() == null ? PartitioningType.Range.toExpression(table) : parentTable.getPartitioning().getPartitioningType().toExpression(table);
            if (value != null) {
                return value;
            }
        }
        return "";
    }

    public static boolean schemaExists(Object schema, Object obj) {
        Schema sc;
        Catalog catalog;
        if (obj == null) {
            return true;
        }
        SchemaCollection schemas = null;
        if (obj instanceof AbstractDbObjectCollection) {
            catalog = (Catalog)((AbstractDbObjectCollection)obj).getAncestor(Catalog.class);
            if (catalog != null) {
                schemas = catalog.getSchemas();
            }
            if (schema == null) {
                schemas = (SchemaCollection)((AbstractDbObjectCollection)obj).getAncestor(SchemaCollection.class);
            }
        } else {
            catalog = (Catalog)((AbstractDbObject)obj).getAncestor(Catalog.class);
            if (catalog != null) {
                schemas = catalog.getSchemas();
            }
            if (schema == null) {
                schemas = (SchemaCollection)((AbstractDbObject)obj).getAncestor(SchemaCollection.class);
            }
        }
        if (schemas == null) {
            return true;
        }
        if (schema instanceof String) {
            sc = (Schema)schemas.get((String)schema);
            return sc != null;
        }
        if (schema instanceof Schema) {
            sc = (Schema)schemas.get(((Schema)schema).getName());
            return sc != null;
        }
        sc = (Schema)schemas.get(((SchemaNameProperty)schema).getSchemaName());
        return sc != null;
    }

    public static String getProductInfo(DbCommonObject<?> obj) {
        return SchemaUtils.getProductInfo(obj);
    }

    static class IntegerLinkedHashMap
    extends LinkedHashMap<String, Integer> {
        IntegerLinkedHashMap() {
        }

        @Override
        public boolean containsKey(Object obj) {
            return true;
        }

        @Override
        public Integer get(Object obj) {
            Integer val = (Integer)super.get(obj);
            if (val == null) {
                return 0;
            }
            return val;
        }
    }

    public static class DbValueInfo {
        private Set<String> values = CommonUtils.treeSet();
        private boolean booleanValue = false;

        public Set<String> getValues() {
            return this.values;
        }

        public boolean isBooleanValue() {
            return this.booleanValue;
        }

        public void setValues(Set<String> values) {
            this.values = values;
        }

        public void setBooleanValue(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DbValueInfo)) {
                return false;
            }
            DbValueInfo other = (DbValueInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$values = this.getValues();
            Set<String> other$values = other.getValues();
            if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
                return false;
            }
            return this.isBooleanValue() == other.isBooleanValue();
        }

        protected boolean canEqual(Object other) {
            return other instanceof DbValueInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            result = result * 59 + (this.isBooleanValue() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HtmlUtils.DbValueInfo(values=" + this.getValues() + ", booleanValue=" + this.isBooleanValue() + ")";
        }
    }
}

