/**
 * Copyright (C) 2007-2018 Tatsuo Satoh <multisqllib@gmail.com>
 *
 * This file is part of sqlapp-command.
 *
 * sqlapp-command is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * sqlapp-command is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with sqlapp-command.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sqlapp.data.db.command;

import java.util.List;

import com.sqlapp.data.schemas.DbCommonObject;

/**
 * スキーマオブジェクトの変換用ハンドラー
 * 
 * @author tatsuo satoh
 * 
 */
public class ConvertHandler {

	private AbstractCommand command;

	public ConvertHandler(AbstractCommand command) {
		this.command = command;
	}

	public ConvertHandler() {
	}

	/**
	 * リストオブジェクトの変換用ハンドラー
	 * 
	 * @param list
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public <T extends DbCommonObject> List<T> handle(
			List<? extends DbCommonObject> list) {
		return (List<T>) list;
	}

	/**
	 * @return the command
	 */
	public AbstractCommand getCommand() {
		return command;
	}

	/**
	 * @param command
	 *            the command to set
	 */
	public void setCommand(AbstractCommand command) {
		this.command = command;
	}

}
