/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.db.command.export.TableFileReader;
import com.sqlapp.data.db.command.html.AbstractSchemaFileCommand;
import com.sqlapp.data.db.command.html.HtmlDetailRenderer;
import com.sqlapp.data.db.command.html.HtmlRenderer;
import com.sqlapp.data.db.command.html.HtmlUtils;
import com.sqlapp.data.db.command.html.Menu;
import com.sqlapp.data.db.command.html.MenuDefinition;
import com.sqlapp.data.db.command.html.RelationImageHolder;
import com.sqlapp.data.db.command.html.RenderOptions;
import com.sqlapp.data.db.command.html.Renderer;
import com.sqlapp.data.db.command.html.StyleRenderer;
import com.sqlapp.data.db.command.html.VirtualForeignKeyLoader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.Body;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.DisplayNameProperty;
import com.sqlapp.data.schemas.properties.DisplayRemarksProperty;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.exceptions.InvalidFontNameException;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.command.DotRuntime;
import com.sqlapp.graphviz.command.OutputFormat;
import com.sqlapp.graphviz.schemas.SchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.TableLabelBuilder;
import com.sqlapp.graphviz.schemas.TableNodeBuilder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.FontUtils;
import com.sqlapp.util.LinkedProperties;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class GenerateHtmlCommand
extends AbstractSchemaFileCommand {
    private File templatePath;
    private File diagramsPath;
    private RenderOptions renderOptions = new RenderOptions();
    private transient boolean graphvizInstalled = false;
    private String dot = null;
    private String diagramFont = null;
    private OutputFormat diagramFormat = OutputFormat.svg;
    private ExecutorService executorService = null;
    private boolean multiThread = true;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private boolean placeholders = false;
    private File fileDirectory = null;
    private File directory = null;
    private boolean useSchemaNameDirectory = false;
    private boolean useTableNameDirectory = false;
    private Predicate<File> fileFilter = f -> true;
    private File foreignKeyDefinitionDirectory = null;
    private int cpu;
    private DotRuntime dotRuntime = new DotRuntime();
    private File outputDirectory = new File("./");
    private static final Pattern ID_PATTERN = Pattern.compile("<map.?\\sid=\"(.*?)\".*", 40);

    private TableFileReader createTableFileReader() {
        TableFileReader tableFileReader = new TableFileReader();
        tableFileReader.setContext(this.getContext());
        tableFileReader.setCsvEncoding(this.getCsvEncoding());
        tableFileReader.setDirectory(this.getDirectory());
        tableFileReader.setFileDirectory(this.getFileDirectory());
        tableFileReader.setFileFilter(this.getFileFilter());
        tableFileReader.setJsonConverter(this.getJsonConverter());
        tableFileReader.setPlaceholderPrefix(this.getPlaceholderPrefix());
        tableFileReader.setPlaceholders(this.isPlaceholders());
        tableFileReader.setPlaceholderSuffix(this.getPlaceholderSuffix());
        tableFileReader.setUseSchemaNameDirectory(this.isUseSchemaNameDirectory());
        tableFileReader.setUseTableNameDirectory(this.isUseTableNameDirectory());
        return tableFileReader;
    }

    private VirtualForeignKeyLoader createVirtualForeignKeyLoader() {
        VirtualForeignKeyLoader loader = new VirtualForeignKeyLoader();
        return loader;
    }

    public GenerateHtmlCommand() {
        this.cpu = Runtime.getRuntime().availableProcessors();
    }

    @Override
    protected void create(Catalog catalog) throws Exception {
        String version;
        this.checkInput(catalog);
        if (this.isMultiThread() && this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.cpu);
        }
        TableFileReader tableFileReader = this.createTableFileReader();
        List<TableFileReader.TableFilesPair> tfs = tableFileReader.getTableFilePairs(catalog);
        try {
            tableFileReader.setFiles(tfs);
        }
        catch (IOException | XMLStreamException | EncryptedDocumentException | InvalidFormatException e) {
            this.getExceptionHandler().handle(e);
        }
        VirtualForeignKeyLoader virtualForeignKeyLoader = this.createVirtualForeignKeyLoader();
        virtualForeignKeyLoader.load(catalog, this.getForeignKeyDefinitionDirectory());
        this.diagramsPath = new File(this.getOutputDirectory(), "diagrams");
        this.dotRuntime.setOutputFormat(this.getDiagramFormat());
        this.dotRuntime.setDir(this.diagramsPath);
        if (this.dot != null) {
            this.dotRuntime.setDot(this.dot);
        }
        if ((version = this.dotRuntime.getVersion()) != null) {
            this.graphvizInstalled = true;
        }
        this.setProperties(catalog);
        Menu rootMenu = this.createMenu(catalog);
        ParametersContext context = new ParametersContext();
        this.createCommon(context, rootMenu);
        List futures = CommonUtils.list();
        block8: for (MenuDefinition menuDefinition : MenuDefinition.values()) {
            switch (menuDefinition) {
                case Relationships: {
                    this.createRelationship(catalog, context.clone(), rootMenu.clone(), futures);
                    continue block8;
                }
                case Schemas: {
                    this.writeSchemas(catalog, context.clone(), rootMenu.clone(), futures);
                    continue block8;
                }
                case Tables: {
                    this.writeTables(catalog, context.clone(), rootMenu.clone(), futures);
                    continue block8;
                }
                case Packages: 
                case Types: {
                    this.outputMenuAndDetailWithBodys(catalog, context.clone(), rootMenu.clone(), menuDefinition, futures);
                    continue block8;
                }
                default: {
                    this.outputMenuAndDetail(catalog, context.clone(), rootMenu.clone(), menuDefinition, futures);
                }
            }
        }
        this.await(futures);
    }

    private void outputMenuAndDetailWithBodys(Catalog catalog, ParametersContext context, Menu rootMenu, MenuDefinition menuDefinition, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        List list = this.getList(catalog, menuDefinition);
        ParametersContext cloneContext = context.clone();
        this.execute(() -> this.outputMenu(catalog, cloneContext, rootMenu, menuDefinition, list), futures);
        this.outputMenuDetailWithBodys(catalog, cloneContext.clone(), rootMenu.clone(), menuDefinition, list, futures);
    }

    private void outputMenuAndDetail(Catalog catalog, ParametersContext context, Menu rootMenu, MenuDefinition menuDefinition, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        List list = this.getList(catalog, menuDefinition);
        ParametersContext cloneContext = context.clone();
        this.execute(() -> this.outputMenu(catalog, cloneContext, rootMenu, menuDefinition, list), futures);
        if (menuDefinition.hasDetails()) {
            this.outputMenuDetails(catalog, cloneContext.clone(), rootMenu.clone(), menuDefinition, list, futures);
        }
    }

    private void createRelationship(Catalog catalog, ParametersContext context, Menu rootMenu, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        if (!this.graphvizInstalled) {
            return;
        }
        this.execute(() -> {
            List internalFutures = CommonUtils.list();
            this.createImages(catalog, context, rootMenu, internalFutures);
            this.await(internalFutures);
            this.outputMenu(catalog, context, rootMenu, MenuDefinition.Relationships, Collections.emptyList());
        }, futures);
    }

    private void execute(Execute execute, List<Future<?>> futures) {
        Future<?> future = this.submit(() -> {
            try {
                execute.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        futures.add(future);
    }

    private void checkInput(Catalog catalog) {
        if (!CommonUtils.isEmpty((CharSequence)this.getDiagramFont()) && !FontUtils.isValidFontName((String)this.getDiagramFont())) {
            throw new InvalidFontNameException(this.getDiagramFont());
        }
    }

    private void setProperties(Catalog catalog) throws Exception {
        List futures = CommonUtils.list();
        for (MenuDefinition menuDefinition : MenuDefinition.values()) {
            this.execute(() -> {
                List list = menuDefinition.getDatas(catalog);
                if (list.isEmpty()) {
                    return;
                }
                if (!(list.get(0) instanceof NameProperty)) {
                    return;
                }
                LinkedProperties properties = new LinkedProperties();
                this.loadProperties(menuDefinition, this.getDictionaryFileType(), (Properties)properties);
                if (properties.size() == 0) {
                    return;
                }
                for (Object obj : list) {
                    String fullName = this.getFullName(obj, true);
                    String fullNameWithoutSchemaName = this.getFullName(obj, false);
                    String name = this.getName(obj);
                    String value = this.getValue((Properties)properties, SchemaProperties.DISPLAY_NAME.getLabel(), fullName, fullNameWithoutSchemaName, name);
                    if (!CommonUtils.isEmpty((CharSequence)value)) {
                        ((DisplayNameProperty)obj).setDisplayName(value);
                    }
                    if (CommonUtils.isEmpty((CharSequence)(value = this.getValue((Properties)properties, SchemaProperties.DISPLAY_REMARKS.getLabel(), fullName, fullNameWithoutSchemaName, name)))) continue;
                    ((DisplayRemarksProperty)obj).setDisplayRemarks(value);
                }
            }, futures);
        }
        this.await(futures);
    }

    private String getValue(Properties properties, String type, String ... names) {
        for (String name : names) {
            String value = properties.getProperty(name + "." + type);
            if (CommonUtils.isEmpty((CharSequence)value)) continue;
            return value;
        }
        return null;
    }

    protected void createCommon(ParametersContext context, Menu rootMenu) {
        StyleRenderer styleRenderer = new StyleRenderer();
        this.initialize(styleRenderer);
        String text = styleRenderer.render(context);
        context.put("style", (Object)text);
        context.put("createdAt", (Object)new Date());
        context.put("_diagramExtension", (Object)this.getDiagramFormat().getExtension());
    }

    protected Menu createMenu(Catalog catalog) {
        Menu rootMenu = new Menu();
        MenuDefinition.toMenus(catalog).forEach(menu -> rootMenu.addChild((Menu)menu));
        return rootMenu;
    }

    protected void createImages(Catalog catalog, ParametersContext context, Menu rootMenu, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        List list = MenuDefinition.Tables.getDatas(catalog);
        String largeName = "_summary_relations_large";
        this.execute(() -> {
            SchemaGraphBuilder schemaGraphBuilder = this.createSchemaGraphBuilder();
            RelationImageHolder holder = this.createRelationLargeImages("_summary_relations_large", catalog, schemaGraphBuilder, false);
            context.put("_summary_relations_large", (Object)holder);
        }, futures);
        String largeNameLogical = "_summary_relations_large_logical";
        this.execute(() -> {
            SchemaGraphBuilder schemaGraphBuilder = this.createSchemaGraphBuilder();
            RelationImageHolder holder = this.createRelationLargeImages("_summary_relations_large_logical", catalog, schemaGraphBuilder, true);
            if (holder != null) {
                context.put("_summary_relations_large_logical", (Object)holder);
            }
        }, futures);
        String smallName = "_summary_relations_small";
        this.execute(() -> {
            SchemaGraphBuilder schemaGraphBuilder = this.createSchemaGraphBuilder();
            RelationImageHolder imapSmall = this.createRelationSmallImage("_summary_relations_small", list, schemaGraphBuilder, false);
            if (imapSmall != null) {
                imapSmall.replaceImageMap("../tables", "tables");
                context.put("_summary_relations_small", (Object)imapSmall);
            }
        }, futures);
        String smallNameLogical = "_summary_relations_small_logical";
        this.execute(() -> {
            SchemaGraphBuilder schemaGraphBuilder = this.createSchemaGraphBuilder();
            RelationImageHolder imapSmall = this.createRelationSmallImage("_summary_relations_small_logical", list, schemaGraphBuilder, true);
            if (imapSmall != null) {
                imapSmall.replaceImageMap("../tables", "tables");
                context.put("_summary_relations_small_logical", (Object)imapSmall);
            }
        }, futures);
    }

    private Future<?> submit(Runnable \uff52unnable) {
        if (this.isMultiThread() && this.cpu > 1) {
            Future<?> future = this.executorService.submit(\uff52unnable);
            return future;
        }
        \uff52unnable.run();
        Future<Object> future = new Future<Object>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                return null;
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return null;
            }
        };
        return future;
    }

    private SchemaGraphBuilder createSchemaGraphBuilder() {
        SchemaGraphBuilder schemaGraphBuilder = new SchemaGraphBuilder();
        if (!CommonUtils.isEmpty((CharSequence)this.getDiagramFont())) {
            schemaGraphBuilder.drawOption().setFont(this.getDiagramFont());
        }
        return schemaGraphBuilder;
    }

    protected RelationImageHolder createRelationLargeImages(String name, Catalog catalog, SchemaGraphBuilder schemaGraphBuilder, boolean logical) {
        Optional<Table> optional;
        if (logical && !(optional = catalog.getSchemas().stream().flatMap(s -> s.getTables().stream()).filter(t -> this.hasDisplayName((Table)t)).findFirst()).isPresent()) {
            return null;
        }
        schemaGraphBuilder.drawOption().setWithRelationName(true);
        schemaGraphBuilder.drawOption().setTableFilter(table -> true);
        schemaGraphBuilder.tableNodeBuilder(TableNodeBuilder.create().labelBuilder(t -> {
            TableLabelBuilder tableLabelBuilder = TableLabelBuilder.create();
            if (logical) {
                tableLabelBuilder.tableTableHeaderBuilder().name(tbl -> (String)CommonUtils.coalesce((Object)tbl.getDisplayName(), (Object)tbl.getName()));
                tableLabelBuilder.tableColumnCellBuilder().name(c -> (String)CommonUtils.coalesce((Object)c.getDisplayName(), (Object)c.getName()));
            }
            return tableLabelBuilder;
        }));
        return this.createRelationImages(name, catalog, schemaGraphBuilder);
    }

    private RelationImageHolder createRelationSmallImage(String name, List<Table> list, SchemaGraphBuilder schemaGraphBuilder, boolean logical) {
        if (logical && !this.hasDisplayName(list)) {
            return null;
        }
        Optional<Table> optional = list.stream().filter(t -> t.getConstraints().getForeignKeyConstraints().size() > 0).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        schemaGraphBuilder.drawOption().setWithRelationName(false);
        schemaGraphBuilder.drawOption().setTableFilter(table -> table.getChildRelations().size() > 0 || table.getConstraints().getForeignKeyConstraints().size() > 0);
        schemaGraphBuilder.tableNodeBuilder(TableNodeBuilder.create().labelBuilder(t -> {
            TableLabelBuilder tableLabelBuilder = TableLabelBuilder.createSimple();
            if (logical) {
                tableLabelBuilder.tableTableHeaderBuilder().name(tbl -> (String)CommonUtils.coalesce((Object)tbl.getDisplayName(), (Object)tbl.getName()));
                tableLabelBuilder.tableColumnCellBuilder().name(c -> (String)CommonUtils.coalesce((Object)c.getDisplayName(), (Object)c.getName()));
            }
            return tableLabelBuilder;
        }));
        schemaGraphBuilder.drawOption().setColumnFilter(column -> {
            if (column.isPrimaryKey()) {
                return true;
            }
            if (column.isForeignKey()) {
                return true;
            }
            return column.getOrdinal() < 5;
        });
        return this.createRelationImages(name, list, schemaGraphBuilder);
    }

    private boolean hasDisplayName(Collection<Table> c) {
        Optional<Table> optional = c.stream().filter(t -> this.hasDisplayName((Table)t)).findFirst();
        return optional.isPresent();
    }

    protected RelationImageHolder createRelationImages(String name, Catalog catalog, SchemaGraphBuilder schemaGraphBuilder) {
        Graph graph = schemaGraphBuilder.createGraph(name);
        catalog.getSchemas().forEach(s -> schemaGraphBuilder.create(s, graph));
        if (!CommonUtils.isEmpty((CharSequence)this.getDiagramFont())) {
            schemaGraphBuilder.drawOption().setFont(this.getDiagramFont());
        }
        File dotFile = new File(this.diagramsPath, name + ".dot");
        File imageFile = new File(this.diagramsPath, name + "." + this.getDiagramFormat().getExtension());
        FileUtils.writeText((String)dotFile.getAbsolutePath(), (String)"UTF8", (String[])new String[]{graph.toString()});
        this.dotRuntime.setOutputFormat(this.getDiagramFormat());
        String imageMap = this.dotRuntime.execute(dotFile.getAbsolutePath(), imageFile.getAbsolutePath());
        String imageMapId = this.convertImageMap(imageMap);
        RelationImageHolder holder = new RelationImageHolder(imageFile, imageMapId, imageMap);
        if (this.getDiagramFormat().isText()) {
            holder.setContent(FileUtils.readText((File)imageFile, (String)"UTF8"));
        }
        return holder;
    }

    protected RelationImageHolder createRelationImages(String name, Collection<Table> list, SchemaGraphBuilder schemaGraphBuilder) {
        Graph graph = schemaGraphBuilder.createGraph(name);
        if (!CommonUtils.isEmpty((CharSequence)this.getDiagramFont())) {
            schemaGraphBuilder.drawOption().setFont(this.getDiagramFont());
        }
        schemaGraphBuilder.create(list, graph);
        File dotFile = new File(this.diagramsPath, name + ".dot");
        File imageFile = new File(this.diagramsPath, name + "." + this.getDiagramFormat().getExtension());
        FileUtils.writeText((String)dotFile.getAbsolutePath(), (String)"UTF8", (String[])new String[]{graph.toString()});
        this.dotRuntime.setOutputFormat(this.getDiagramFormat());
        String imageMap = this.dotRuntime.execute(dotFile.getAbsolutePath(), imageFile.getAbsolutePath());
        String imageMapId = this.convertImageMap(imageMap);
        RelationImageHolder holder = new RelationImageHolder(imageFile, imageMapId, imageMap);
        if (this.getDiagramFormat().isText()) {
            holder.setContent(FileUtils.readText((File)imageFile, (String)"UTF8"));
        }
        return holder;
    }

    private String convertImageMap(String imageMap) {
        String imageMapId = null;
        if (!CommonUtils.isEmpty((CharSequence)imageMap)) {
            imageMap = imageMap.replace("\\", "");
            imageMap = imageMap.replaceAll("\"\\s*/\\s*\"", "");
            Matcher matcher = ID_PATTERN.matcher(imageMap = imageMap.replace("tables/", "../tables/"));
            if (matcher.matches()) {
                imageMapId = matcher.group(1);
            }
        }
        return imageMapId;
    }

    protected void initialize(Renderer renderer) {
    }

    protected void writeSchemas(Catalog catalog, ParametersContext context, Menu rootMenu, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        List list = this.getList(catalog, MenuDefinition.Schemas);
        this.execute(() -> this.outputMenu(catalog, context, rootMenu, MenuDefinition.Schemas, list), futures);
        this.outputMenuDetails(catalog, context.clone(), rootMenu.clone(), MenuDefinition.Schemas, list, (con, obj) -> {
            Schema val = (Schema)obj;
            SchemaGraphBuilder schemaGraphBuilder = this.createSchemaGraphBuilder();
            RelationImageHolder holder = this.createSchemaRelation(val, schemaGraphBuilder, false);
            if (holder != null && holder.getImageMap() != null) {
                con.put("relations", (Object)holder);
            }
            if ((holder = this.createSchemaRelation(val, schemaGraphBuilder, true)) != null) {
                con.put("relations_logical", (Object)holder);
            }
        }, futures);
    }

    protected void writeTables(Catalog catalog, ParametersContext context, Menu rootMenu, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        List list = this.getList(catalog, MenuDefinition.Tables);
        this.execute(() -> this.outputMenu(catalog, context, rootMenu, MenuDefinition.Tables, list), futures);
        this.outputMenuDetails(catalog, context.clone(), rootMenu.clone(), MenuDefinition.Tables, list, (con, obj) -> {
            SchemaGraphBuilder schemaGraphBuilder = this.createSchemaGraphBuilder();
            Table val = (Table)obj;
            if (!this.hasRelation(val)) {
                return;
            }
            RelationImageHolder holder = this.createTableRelationImage(val, schemaGraphBuilder, false);
            if (holder != null) {
                con.put("relations", (Object)holder);
            }
            if ((holder = this.createTableRelationImage(val, schemaGraphBuilder, true)) != null) {
                con.put("relations_logical", (Object)holder);
            }
        }, futures);
    }

    private boolean hasRelation(Table table) {
        if (!CommonUtils.isEmpty((Collection)table.getChildRelations())) {
            return true;
        }
        if (!CommonUtils.isEmpty((Collection)table.getConstraints().getForeignKeyConstraints())) {
            return true;
        }
        if (!CommonUtils.isEmpty((Collection)table.getInherits())) {
            return true;
        }
        if (table.getPartitionParent() != null) {
            return true;
        }
        return table.getPartitioning() != null && !CommonUtils.isEmpty((Collection)table.getPartitioning().getPartitionTables());
    }

    protected void outputMenuDetailWithBodys(Catalog catalog, ParametersContext context, Menu rootMenu, MenuDefinition menuDefinition, List<?> list, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        HtmlRenderer htmlRenderer = this.createHtmlDetailRenderer();
        String name = SchemaUtils.getSingularName((String)menuDefinition.toString()).toLowerCase();
        htmlRenderer.setTemplateResource(name + ".html");
        File path = new File(this.getOutputDirectory(), name + "s");
        File bodyPath = new File(this.getOutputDirectory(), name + "bodies");
        HtmlDetailRenderer detailHtmlRenderer = new HtmlDetailRenderer();
        detailHtmlRenderer.setTemplateResource(name + "body.html");
        for (Object obj : list) {
            this.execute(() -> {
                ParametersContext con = context.clone();
                Menu menu = rootMenu.clone();
                AbstractDbObject body = ((Body)obj).getBody();
                String detailName = HtmlUtils.objectFullPath(obj);
                this.writeDetail(htmlRenderer, path, obj, con, menu, detailName);
                if (body != null) {
                    String detailBodyName = HtmlUtils.objectFullPath(body);
                    this.writeDetail(detailHtmlRenderer, bodyPath, body, con, menu, detailBodyName);
                }
            }, futures);
        }
    }

    private HtmlRenderer createHtmlRenderer() {
        HtmlRenderer htmlRenderer = new HtmlRenderer();
        htmlRenderer.setRenderOptions(this.getRenderOptions());
        return htmlRenderer;
    }

    private HtmlRenderer createHtmlDetailRenderer() {
        HtmlDetailRenderer htmlRenderer = new HtmlDetailRenderer();
        htmlRenderer.setRenderOptions(this.getRenderOptions());
        return htmlRenderer;
    }

    protected void outputMenuDetails(Catalog catalog, ParametersContext context, Menu rootMenu, MenuDefinition menuDefinition, List<?> list, BiConsumer<ParametersContext, Object> consumer, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        HtmlRenderer htmlRenderer = this.createHtmlDetailRenderer();
        String name = SchemaUtils.getSingularName((String)menuDefinition.toString()).toLowerCase();
        htmlRenderer.setTemplateResource(name + ".html");
        File path = new File(this.getOutputDirectory(), menuDefinition.toString().toLowerCase());
        for (Object obj : list) {
            this.execute(() -> {
                Menu menu = rootMenu.clone();
                ParametersContext con = context.clone();
                if (consumer != null) {
                    consumer.accept(con, obj);
                }
                String detailName = HtmlUtils.objectFullPath(obj);
                this.writeDetail(htmlRenderer, path, obj, con, menu, detailName);
            }, futures);
        }
    }

    private void await(List<Future<?>> futures) throws InterruptedException, ExecutionException {
        for (Future<?> future : futures) {
            future.get();
        }
    }

    protected void outputMenuDetails(Catalog catalog, ParametersContext context, Menu rootMenu, MenuDefinition menuDefinition, List<?> list, List<Future<?>> futures) throws InterruptedException, ExecutionException {
        this.outputMenuDetails(catalog, context, rootMenu, menuDefinition, list, null, futures);
    }

    protected void writeDetail(HtmlRenderer renderer, File path, Object obj, ParametersContext context, Menu rootMenu, String name) {
        context.put("obj", obj);
        context.put("context", (Object)context);
        rootMenu.setActiveRecursive(false);
        rootMenu.setRelativePathRecursive("../");
        context.put("rootMenu", (Object)rootMenu);
        String text = this.render(renderer, context);
        this.writeText(new File(path, name + ".html"), text);
        rootMenu.setRelativePath(null);
    }

    private String render(HtmlRenderer renderer, ParametersContext context) {
        try {
            return renderer.render(context);
        }
        catch (Exception e) {
            throw new RuntimeException("template=" + renderer.getTemplateResource(), e);
        }
    }

    private RelationImageHolder createTableRelationImage(Table table, SchemaGraphBuilder schemaGraphBuilder, boolean logical) {
        Set tables = CommonUtils.set();
        tables.add(table);
        table.getChildRelations().forEach(fk -> tables.add(fk.getTable()));
        table.getConstraints().getForeignKeyConstraints().forEach(fk -> tables.add(fk.getRelatedTable()));
        this.setParentPartitionTables(table, tables);
        this.setChildPartitionTables(table, tables);
        if (tables.size() == 0) {
            return null;
        }
        if (logical && !this.hasDisplayName(tables)) {
            return null;
        }
        schemaGraphBuilder.drawOption().setWithRelationName(false);
        schemaGraphBuilder.drawOption().setTableFilter(t -> tables.contains(t));
        schemaGraphBuilder.tableNodeBuilder(TableNodeBuilder.create().labelBuilder(t -> {
            TableLabelBuilder tableLabelBuilder = t == table ? TableLabelBuilder.create() : TableLabelBuilder.createSimple();
            if (logical) {
                tableLabelBuilder.tableTableHeaderBuilder().name(tbl -> (String)CommonUtils.coalesce((Object)tbl.getDisplayName(), (Object)tbl.getName()));
                tableLabelBuilder.tableColumnCellBuilder().name(c -> (String)CommonUtils.coalesce((Object)c.getDisplayName(), (Object)c.getName()));
            }
            return tableLabelBuilder;
        }));
        if (logical) {
            return this.createRelationImages(HtmlUtils.objectFullPath(table) + "_logical", tables, schemaGraphBuilder);
        }
        return this.createRelationImages(HtmlUtils.objectFullPath(table), tables, schemaGraphBuilder);
    }

    private void setParentPartitionTables(Table table, Set<Table> tables) {
        if (table == null) {
            return;
        }
        if (table.getPartitionParent() == null) {
            return;
        }
        tables.add(table.getPartitionParent().getTable());
        this.setParentPartitionTables(table.getPartitionParent().getTable(), tables);
    }

    private void setChildPartitionTables(Table table, Set<Table> tables) {
        if (table == null) {
            return;
        }
        if (table.getPartitioning() != null && !CommonUtils.isEmpty((Collection)table.getPartitioning().getPartitionTables())) {
            table.getPartitioning().getPartitionTables().forEach(t -> tables.add((Table)t));
        }
    }

    private RelationImageHolder createSchemaRelation(Schema schema, SchemaGraphBuilder schemaGraphBuilder, boolean logical) {
        if (schema.getTables().size() == 0) {
            return null;
        }
        if (logical && !this.hasDisplayName((Collection<Table>)schema.getTables())) {
            return null;
        }
        schemaGraphBuilder.drawOption().setWithRelationName(false);
        schemaGraphBuilder.tableNodeBuilder(TableNodeBuilder.create().labelBuilder(t -> {
            TableLabelBuilder tableLabelBuilder = TableLabelBuilder.createSimple();
            if (logical) {
                tableLabelBuilder.tableTableHeaderBuilder().name(tbl -> (String)CommonUtils.coalesce((Object)tbl.getDisplayName(), (Object)tbl.getName()));
                tableLabelBuilder.tableColumnCellBuilder().name(c -> (String)CommonUtils.coalesce((Object)c.getDisplayName(), (Object)c.getName()));
            }
            return tableLabelBuilder;
        }));
        if (logical) {
            return this.createRelationImages(HtmlUtils.objectFullPath(schema) + "_logical", (Collection<Table>)schema.getTables(), schemaGraphBuilder);
        }
        return this.createRelationImages(HtmlUtils.objectFullPath(schema), (Collection<Table>)schema.getTables(), schemaGraphBuilder);
    }

    private boolean hasDisplayName(Table table) {
        if (table.getDisplayName() != null) {
            return true;
        }
        for (Column column : table.getColumns()) {
            if (column.getDisplayName() == null) continue;
            return true;
        }
        return false;
    }

    private void outputMenu(Catalog catalog, ParametersContext context, Menu rootMenu, MenuDefinition menuDefinition, List<?> list) {
        if (!menuDefinition.hasData(catalog)) {
            return;
        }
        String name = menuDefinition.toString().toLowerCase();
        HtmlRenderer renderer = this.createHtmlRenderer();
        renderer.setTemplateResource(menuDefinition.getHtmlName());
        this.initialize(renderer);
        rootMenu.setActive(menuDefinition);
        context.put("rootMenu", (Object)rootMenu);
        context.put("catalog", (Object)catalog);
        context.put("title", (Object)menuDefinition.getDisplayName());
        context.put("name", (Object)name);
        context.put(name, list);
        context.put("list", list);
        context.put("context", (Object)context);
        ParametersContext map = HtmlUtils.analyzeAllProperties(list);
        context.put("_prefix", (Object)map);
        map.forEach((k, v) -> context.put(k, v));
        if (menuDefinition == MenuDefinition.Columns || menuDefinition == MenuDefinition.Domains) {
            context.put("columns", (Object)map);
        }
        rootMenu.setRelativePathRecursive(null);
        String text = this.render(renderer, context);
        this.writeText(new File(this.getOutputDirectory(), menuDefinition.getHtmlName()), text);
    }

    private <T> List<T> getList(Catalog catalog, MenuDefinition menuDefinition) {
        if (!menuDefinition.hasData(catalog)) {
            return Collections.emptyList();
        }
        List list = menuDefinition.getDatas(catalog);
        return list;
    }

    private void writeText(File file, String text) {
        String[] args = text.split("\n");
        List texts = CommonUtils.list();
        for (String arg : args) {
            if (arg.trim().length() == 0) continue;
            texts.add(arg);
        }
        FileUtils.writeText((File)file, (String)"UTF8", (String[])texts.toArray(new String[0]));
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getDiagramFont() {
        return this.diagramFont;
    }

    public void setDiagramFont(String diagramFont) {
        this.diagramFont = diagramFont;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(File templatePath) {
        this.templatePath = templatePath;
    }

    public RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    public String getDot() {
        return this.dot;
    }

    public void setDot(String dot) {
        this.dot = dot;
    }

    public boolean isMultiThread() {
        return this.multiThread;
    }

    public void setMultiThread(boolean multiThread) {
        this.multiThread = multiThread;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public boolean isPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(boolean placeholders) {
        this.placeholders = placeholders;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getFileDirectory() {
        return this.fileDirectory;
    }

    public void setFileDirectory(File fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    public boolean isUseSchemaNameDirectory() {
        return this.useSchemaNameDirectory;
    }

    public void setUseSchemaNameDirectory(boolean useSchemaNameDirectory) {
        this.useSchemaNameDirectory = useSchemaNameDirectory;
    }

    public boolean isUseTableNameDirectory() {
        return this.useTableNameDirectory;
    }

    public void setUseTableNameDirectory(boolean useTableNameDirectory) {
        this.useTableNameDirectory = useTableNameDirectory;
    }

    public Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(Predicate<File> fileFilter) {
        this.fileFilter = fileFilter;
    }

    public File getForeignKeyDefinitionDirectory() {
        return this.foreignKeyDefinitionDirectory;
    }

    public void setForeignKeyDefinitionDirectory(File foreignKeyDefinitionDirectory) {
        this.foreignKeyDefinitionDirectory = foreignKeyDefinitionDirectory;
    }

    public OutputFormat getDiagramFormat() {
        return this.diagramFormat;
    }

    public void setDiagramFormat(OutputFormat diagramFormat) {
        this.diagramFormat = diagramFormat;
    }

    public void setDiagramFormat(String diagramFormat) {
        this.diagramFormat = OutputFormat.parse((String)diagramFormat);
    }

    @FunctionalInterface
    static interface ExecuteWithMenuDifinition {
        public void run(MenuDefinition var1) throws Exception;
    }

    @FunctionalInterface
    static interface Execute {
        public void run() throws Exception;
    }
}

