/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.version;

import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.ToStringBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbVersionFileHandler {
    private File upSqlDirectory;
    private File downSqlDirectory;
    private final Pattern fileNamePattern = Pattern.compile("([0-9]{1,20})\\_(.*\\.sql)");
    private String encoding = "UTF8";
    private SqlSplitter sqlSplitter = new SqlSplitter();

    protected String getResource(String fileName, String encoding) {
        InputStream is = FileUtils.getInputStream(this.getClass(), (String)fileName);
        String text = FileUtils.readText((InputStream)is, (String)encoding);
        return text;
    }

    public File getUpSqlDirectory() {
        return this.upSqlDirectory;
    }

    public void setUpSqlDirectory(File upSqlDirectory) {
        this.upSqlDirectory = upSqlDirectory;
    }

    public void setUpSqlDirectory(String upSqlDirectory) {
        this.upSqlDirectory = new File(upSqlDirectory);
    }

    public File getDownSqlDirectory() {
        return this.downSqlDirectory;
    }

    public void setDownSqlDirectory(File downSqlDirectory) {
        this.downSqlDirectory = downSqlDirectory;
    }

    public void setDownSqlDirectory(String downSqlDirectory) {
        this.downSqlDirectory = new File(downSqlDirectory);
    }

    public void add(String description) throws IOException {
        this.add(new Date(), description);
    }

    public void add(Date date, String description) throws IOException {
        this.add(DateUtils.format((Date)date, (String)"yyyyMMddHHmmssSSS"), description);
    }

    public SqlSplitter getSqlSplitter() {
        return this.sqlSplitter;
    }

    public void setSqlSplitter(SqlSplitter sqlSplitter) {
        this.sqlSplitter = sqlSplitter;
    }

    public void add(String version, String description) throws IOException {
        String current = this.getFileName(version, description);
        File file = new File(this.upSqlDirectory, current);
        if (this.downSqlDirectory != null && !CommonUtils.eq((Object)this.upSqlDirectory.getAbsolutePath(), (Object)this.downSqlDirectory.getAbsolutePath())) {
            if (!file.exists()) {
                FileUtils.createParentDirectory((File)file);
                file.createNewFile();
            }
            if (!(file = new File(this.downSqlDirectory, current)).exists()) {
                FileUtils.createParentDirectory((File)file);
                file.createNewFile();
            }
        } else if (!file.exists()) {
            FileUtils.createParentDirectory((File)file);
            FileUtils.writeText((String)file.getAbsolutePath(), (String)this.getEncoding(), (String[])new String[]{this.getResource("template.sql", "UTF8")});
        }
    }

    public void addUpDownSql(Date date, String name, String upSql, String downSql) throws IOException {
        this.addUpDownSql(DateUtils.format((Date)date, (String)"yyyyMMddHHmmssSSS"), name, upSql, downSql);
    }

    public void addUpDownSql(String prefix, String name, String upSql, String downSql) throws IOException {
        String current = this.getFileName(prefix, name);
        File file = new File(this.upSqlDirectory, current);
        if (this.downSqlDirectory != null && !CommonUtils.eq((Object)this.upSqlDirectory.getAbsolutePath(), (Object)this.downSqlDirectory.getAbsolutePath())) {
            if (!file.exists()) {
                FileUtils.createParentDirectory((File)file);
                FileUtils.writeText((String)file.getAbsolutePath(), (String)this.getEncoding(), (String[])new String[]{upSql});
            }
            if (!(file = new File(this.downSqlDirectory, current)).exists()) {
                FileUtils.createParentDirectory((File)file);
                FileUtils.writeText((String)file.getAbsolutePath(), (String)this.getEncoding(), (String[])new String[]{downSql});
            }
        } else if (!file.exists()) {
            FileUtils.createParentDirectory((File)file);
            FileUtils.writeText((String)file.getAbsolutePath(), (String)this.getEncoding(), (String[])new String[]{this.getResource("template.sql", "UTF8")});
        }
    }

    private String getFileName(String prefix, String name) {
        String current = prefix.replace(' ', '_') + "_" + name.replace(' ', '_') + ".sql";
        return current;
    }

    public void remove(String prefix, String name) throws IOException {
        String current = this.getFileName(prefix, name);
        File file = new File(this.upSqlDirectory, current);
        if (this.downSqlDirectory != null && !CommonUtils.eq((Object)this.upSqlDirectory.getAbsolutePath(), (Object)this.downSqlDirectory.getAbsolutePath())) {
            if (!file.exists()) {
                file.delete();
            }
            if (!(file = new File(this.downSqlDirectory, current)).exists()) {
                file.delete();
            }
        } else if (file.exists()) {
            file.delete();
        }
    }

    public List<SqlFile> read() {
        SqlFile sqlFile;
        File[] files;
        List result = CommonUtils.list();
        Map map = CommonUtils.map();
        if (this.upSqlDirectory.exists() && (files = this.upSqlDirectory.listFiles()) != null) {
            for (File file : files) {
                sqlFile = this.getTargetSqlFile(file);
                if (sqlFile == null) continue;
                sqlFile.setUpSqlFile(file);
                map.put(file.getName(), sqlFile);
                result.add(sqlFile);
            }
        }
        if (this.downSqlDirectory != null && !CommonUtils.eq((Object)this.upSqlDirectory.getAbsolutePath(), (Object)this.downSqlDirectory.getAbsolutePath()) && (files = this.downSqlDirectory.listFiles()) != null) {
            for (File file : files) {
                sqlFile = (SqlFile)map.get(file.getName());
                if (sqlFile == null && (sqlFile = this.getTargetSqlFile(file)) != null) {
                    result.add(sqlFile);
                    continue;
                }
                if (sqlFile == null) continue;
                sqlFile.setDownSqlFile(file);
            }
        }
        Collections.sort(result);
        return result;
    }

    private SqlFile getTargetSqlFile(File file) {
        if (!file.isFile()) {
            return null;
        }
        if (!file.getAbsolutePath().endsWith(".sql")) {
            return null;
        }
        String name = file.getName();
        Matcher matcher = this.fileNamePattern.matcher(name);
        if (!matcher.matches()) {
            return null;
        }
        SqlFile sqlFile = new SqlFile(Long.valueOf(matcher.group(1)), this.getSqlSplitter());
        sqlFile.setEncoding(this.getEncoding());
        return sqlFile;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public static class SqlFile
    implements Comparable<SqlFile> {
        private Long versionNumber;
        private File upSqlFile;
        private File downSqlFile;
        private String encoding;
        private final SqlSplitter sqlSplitter;
        private List<SqlSplitter.SplitResult> upSqls = null;
        private List<SqlSplitter.SplitResult> downSqls = null;
        private static final Pattern UNDO_PATTERN = Pattern.compile("--[\\s]*//@UNDO\\s*", 2);

        public SqlFile(Long versionNumber, SqlSplitter sqlSplitter) {
            this.versionNumber = versionNumber;
            this.sqlSplitter = sqlSplitter;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public File getUpSqlFile() {
            return this.upSqlFile;
        }

        public void setUpSqlFile(File upSqlFile) {
            this.upSqlFile = upSqlFile;
        }

        public File getDownSqlFile() {
            return this.downSqlFile;
        }

        public void setDownSqlFile(File downSqlFile) {
            this.downSqlFile = downSqlFile;
        }

        public SqlSplitter getSqlSplitter() {
            return this.sqlSplitter;
        }

        public List<SqlSplitter.SplitResult> getUpSqls() {
            if (this.upSqls == null) {
                String text = FileUtils.readText((File)this.getUpSqlFile(), (String)this.getEncoding());
                List splits = this.getSqlSplitter().parse(text);
                boolean undo = false;
                List up = CommonUtils.list();
                List down = CommonUtils.list();
                for (SqlSplitter.SplitResult splitResult : splits) {
                    if (splitResult.getTextType().isComment()) {
                        Matcher matcher = UNDO_PATTERN.matcher(splitResult.getText());
                        if (!matcher.matches()) continue;
                        undo = true;
                        continue;
                    }
                    if (undo) {
                        down.add(splitResult);
                        continue;
                    }
                    up.add(splitResult);
                }
                this.upSqls = up;
                if (undo) {
                    this.downSqls = down;
                }
            }
            return this.upSqls;
        }

        public List<SqlSplitter.SplitResult> getDownSqls() {
            this.getUpSqls();
            if (this.downSqls == null && this.getDownSqlFile() != null) {
                List splits;
                String text = FileUtils.readText((File)this.getDownSqlFile(), (String)this.getEncoding());
                this.downSqls = splits = this.getSqlSplitter().parse(text);
            }
            return this.downSqls;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder(this.getClass());
            builder.add("versionNumber", (Object)this.versionNumber);
            if (this.upSqlFile != null) {
                builder.add("\nupSqlFile", this.upSqlFile.getAbsolutePath());
            }
            if (this.downSqlFile != null) {
                builder.add("\ndownSqlFile", this.downSqlFile.getAbsolutePath());
            }
            return builder.toString();
        }

        @Override
        public int compareTo(SqlFile o) {
            return this.versionNumber.compareTo(o.versionNumber);
        }
    }
}

