/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.DefaultSchemaEqualsHandler;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.exceptions.CommandException;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class DiffCommand
extends AbstractCommand {
    private File originalFile;
    private File targetFile;
    private EqualsHandler equalsHandler = DefaultSchemaEqualsHandler.getInstance();

    @Override
    protected void doRun() {
        DbCommonObject original = null;
        try {
            original = SchemaUtils.readXml((File)this.originalFile);
        }
        catch (FileNotFoundException e) {
            throw new CommandException("path=" + this.originalFile, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new CommandException("path=" + this.originalFile, (Throwable)e);
        }
        catch (IOException e) {
            throw new CommandException("path=" + this.originalFile, (Throwable)e);
        }
        DbCommonObject target = null;
        try {
            target = SchemaUtils.readXml((File)this.targetFile);
        }
        catch (FileNotFoundException e) {
            throw new CommandException("path=" + this.targetFile, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new CommandException("path=" + this.targetFile, (Throwable)e);
        }
        catch (IOException e) {
            throw new CommandException("path=" + this.targetFile, (Throwable)e);
        }
        if (!CommonUtils.eq(original.getClass(), target.getClass())) {
            throw new CommandException("Original and Target class unmatch. original=[" + original.getClass() + "], target=[" + target.getClass() + "].");
        }
        EqualsHandler equalsHandler = this.getEqualsHandler();
        boolean result = original.equals((Object)target, equalsHandler);
        if (!result) {
            this.printResult(original, target, equalsHandler);
        } else {
            this.println("No difference found.");
        }
    }

    private void printResult(DbCommonObject<?> original, DbCommonObject<?> target, EqualsHandler equalsHandler) {
        if (original instanceof DbObject) {
            DbObjectDifference diff = ((DbObject)original).diff((DbObject)target, equalsHandler);
            this.println(diff);
        } else {
            DbObjectDifferenceCollection diff = ((DbObjectCollection)original).diff((DbObjectCollection)target, equalsHandler);
            this.println(diff);
        }
    }

    protected void doExecute(DbCommonObject original, DbCommonObject target) {
        if (original instanceof DbObject) {
            this.doExecute((DbObject)original, (DbObject)target);
        }
        if (original instanceof DbObjectCollection) {
            this.doExecute((DbObjectCollection)original, (DbObjectCollection)target);
        }
    }

    protected void doExecute(DbObject original, DbObject target) {
        original.diff(target, this.getEqualsHandler());
    }

    protected void doExecute(DbObjectCollection original, DbObjectCollection target) {
        original.diff(target, this.getEqualsHandler());
    }

    public EqualsHandler getEqualsHandler() {
        return this.equalsHandler;
    }

    public void setEqualsHandler(EqualsHandler equalsHandler) {
        this.equalsHandler = equalsHandler;
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    public void setOriginalFile(File originalFile) {
        this.originalFile = originalFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }
}

