/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.IntervalDayConverter;
import com.sqlapp.data.converter.IntervalDayToHourConverter;
import com.sqlapp.data.converter.IntervalDayToMinuteConverter;
import com.sqlapp.data.converter.IntervalDayToSecondConverter;
import com.sqlapp.data.converter.IntervalHourConverter;
import com.sqlapp.data.converter.IntervalHourToMinuteConverter;
import com.sqlapp.data.converter.IntervalHourToSecondConverter;
import com.sqlapp.data.converter.IntervalMinuteConverter;
import com.sqlapp.data.converter.IntervalMinuteToSecondConverter;
import com.sqlapp.data.converter.IntervalMonthConverter;
import com.sqlapp.data.converter.IntervalSecondConverter;
import com.sqlapp.data.converter.IntervalYearConverter;
import com.sqlapp.data.converter.IntervalYearToMonthConverter;
import com.sqlapp.data.converter.PipeConverter;
import com.sqlapp.data.db.datatype.BlobType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.data.db.datatype.InetType;
import com.sqlapp.data.db.datatype.IntervalDayToHourType;
import com.sqlapp.data.db.datatype.IntervalDayToMinuteType;
import com.sqlapp.data.db.datatype.IntervalDayToSecondType;
import com.sqlapp.data.db.datatype.IntervalDayType;
import com.sqlapp.data.db.datatype.IntervalHourToMinuteType;
import com.sqlapp.data.db.datatype.IntervalHourToSecondType;
import com.sqlapp.data.db.datatype.IntervalHourType;
import com.sqlapp.data.db.datatype.IntervalMinuteToSecondType;
import com.sqlapp.data.db.datatype.IntervalMinuteType;
import com.sqlapp.data.db.datatype.IntervalMonthType;
import com.sqlapp.data.db.datatype.IntervalSecondType;
import com.sqlapp.data.db.datatype.IntervalYearToMonthType;
import com.sqlapp.data.db.datatype.IntervalYearType;
import com.sqlapp.data.db.datatype.JdbcTypeHandler;
import com.sqlapp.data.db.datatype.MoneyType;
import com.sqlapp.data.db.datatype.NumericType;
import com.sqlapp.data.db.datatype.TimeType;
import com.sqlapp.data.db.datatype.TimestampType;
import com.sqlapp.data.db.datatype.VarcharType;
import com.sqlapp.data.db.datatype.util.ColumnTypeMatcher;
import com.sqlapp.data.db.datatype.util.LengthColumnTypeMatcher;
import com.sqlapp.data.db.datatype.util.PrecisionColumnTypeMatcher;
import com.sqlapp.data.db.dialect.DefaultCase;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGBoxConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGCircleConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGIntervalConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGLineConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGLsegConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGPathConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGPointConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGPolygonConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGBoxConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGCircleConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGIntervalConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGLineConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGLsegConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGPathConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGPointConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGPolygonConverter;
import com.sqlapp.data.db.dialect.postgres.db.datatype.util.PostgresArrayColumnTypeMatcher;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresCatalogReader;
import com.sqlapp.data.db.dialect.postgres.sql.PostgresSqlFactoryRegistry;
import com.sqlapp.data.db.dialect.postgres.util.PostgresJdbcHandler;
import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.JDBCType;
import java.util.function.Function;
import java.util.function.Supplier;

public class Postgres
extends Dialect {
    private static final long serialVersionUID = -7843214207236066501L;
    protected static final Function<ColumnTypeMatcher, ColumnTypeMatcher> columnTypeMatcherConverter = matcher -> new PostgresArrayColumnTypeMatcher((ColumnTypeMatcher)matcher);

    protected Postgres(Supplier<Dialect> nextVersionDialectSupplier) {
        super(nextVersionDialectSupplier);
    }

    protected void registerDataType() {
        this.getDbDataTypes().addChar(32672L, type -> {
            type.setColumnTypeMatcher((ColumnTypeMatcher)new LengthColumnTypeMatcher("(CHAR(ACTER)?|BPCHAR)", ""));
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
            type.setSupportsArray(true);
        });
        this.getDbDataTypes().addVarchar(32672L, type -> type.convertColumnTypeMatchers(columnTypeMatcherConverter));
        this.getDbDataTypes().addVarchar("TEXT", (long)CommonUtils.LEN_1GB, type -> {
            ((VarcharType)((VarcharType)type.setCreateFormat("TEXT")).setFixedLength(true)).setDefaultLength((Number)CommonUtils.LEN_1GB);
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addBlob("BYTEA", (long)CommonUtils.LEN_1GB, type -> {
            ((BlobType)type.setCreateFormat("BYTEA")).setLiteral("decode('", "', 'hex')");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addBoolean("BOOLEAN", type -> {
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addBinary("BIT", (long)CommonUtils.LEN_1GB, type -> {
            type.setLiteral("decode('", "', 'hex')");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addVarBinary("VARBIT", (long)CommonUtils.LEN_1GB, type -> {
            type.setLiteral("decode('", "', 'hex')");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addSmallInt(type -> {
            type.addColumnTypeMatcher(new String[]{"INT2"});
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addInt(type -> {
            type.addColumnTypeMatcher(new String[]{"INT4"});
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addBigInt(type -> {
            type.addColumnTypeMatcher(new String[]{"INT8"});
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addSerial("SERIAL", type -> {
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addBigSerial("BIGSERIAL", type -> {
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addNumeric(type -> {
            type.setMaxPrecision(Integer.valueOf(1000)).setMaxScale(Integer.valueOf(1000));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addUUID("UUID", type -> {
            type.setLiteral("{", "}");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addReal("FLOAT4", type -> {
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addDouble(type -> {
            type.addColumnTypeMatcher(new String[]{"FLOAT8"});
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addMoney("MONEY", type -> {
            ((MoneyType)((MoneyType)((MoneyType)type.setLiteral("", "::text::money")).setSurrogateType(new NumericType().setMaxPrecision(Integer.valueOf(17)).setScale(2))).setFixedPrecision(false)).setFixedScale(false);
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addSqlXml("XML", type -> {
            type.setLiteral("XML '", "'");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addSmallDateTime("abstime", type -> {
            type.setDefaultValueLiteral(this.getCurrentDateFunction());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addDate(type -> {
            type.setDefaultValueLiteral(this.getCurrentDateFunction());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addTime(type -> {
            ((TimeType)type.setDefaultValueLiteral(this.getCurrentTimeFunction())).setLiteral("TIME '", "'");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addTimeWithTimeZone("TIMETZ", type -> {
            ((TimeType)((TimeType)type.setDefaultPrecision(Integer.valueOf(6))).setDefaultValueLiteral(this.getCurrentTimeFunction())).setLiteral("TIME WITH TIME ZONE '", "'");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addTimestamp(type -> {
            ((TimestampType)type.setDefaultValueLiteral(this.getCurrentTimestampFunction())).setLiteral("TIMESTAMP '", "'");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addTimestampWithTimeZone("TIMESTAMPTZ", type -> {
            type.setColumnTypeMatcher((ColumnTypeMatcher)new PrecisionColumnTypeMatcher("TIMESTAMP", "WITH\\s+TIME\\s+ZONE"));
            ((TimestampType)((TimestampType)type.setLiteral("TIMESTAMP WITH TIME ZONE '", "'")).setDefaultPrecision(Integer.valueOf(6))).setDefaultValueLiteral(this.getCurrentTimestampFunction());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addInterval(type -> {
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalYear(type -> {
            ((IntervalYearType)type.setCreateFormat("INTERVAL YAER")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalYearConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalMonth(type -> {
            ((IntervalMonthType)type.setCreateFormat("INTERVAL MONTH")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMonthConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalDay(type -> {
            ((IntervalDayType)type.setCreateFormat("INTERVAL DAY")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalHour(type -> {
            ((IntervalHourType)type.setCreateFormat("INTERVAL HOUR")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalMinute(type -> {
            ((IntervalMinuteType)type.setCreateFormat("INTERVAL MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMinuteConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalSecond(type -> {
            ((IntervalSecondType)type.setCreateFormat("INTERVAL SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalSecondConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalYearToMonth(type -> {
            ((IntervalYearToMonthType)type.setCreateFormat("INTERVAL YAER TO MONTH")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalYearToMonthConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalDayToHour(type -> {
            ((IntervalDayToHourType)type.setCreateFormat("INTERVAL DAY TO HOUR")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToHourConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalDayToMinute(type -> {
            ((IntervalDayToMinuteType)type.setCreateFormat("INTERVAL DAY TO MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToMinuteConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalDayToSecond(type -> {
            ((IntervalDayToSecondType)type.setCreateFormat("INTERVAL DAY TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToSecondConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalHourToMinute(type -> {
            ((IntervalHourToMinuteType)type.setCreateFormat("INTERVAL HOUR TO MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourToMinuteConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalHourToSecond(type -> {
            ((IntervalHourToSecondType)type.setCreateFormat("INTERVAL HOUR TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourToSecondConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addIntervalMinuteToSecond(type -> {
            ((IntervalMinuteToSecondType)type.setCreateFormat("INTERVAL MINUTE TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMinuteToSecondConverter()));
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addInetType(type -> {
            ((InetType)type.setLiteralPrefix("inet '")).setLiteralSuffix("'");
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addCidrType(type -> {
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addMacAddrType(type -> {
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addRowId("OID", type -> {
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addPointType(type -> {
            type.setJdbcTypeHandler(this.getPointConverter());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addCircleType(type -> {
            type.setJdbcTypeHandler(this.getCircleConverter());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addBoxType(type -> {
            type.setJdbcTypeHandler(this.getBoxConverter());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addLineType(type -> {
            type.setJdbcTypeHandler(this.getLineConverter());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addLsegType(type -> {
            type.setJdbcTypeHandler(this.getLsegConverter());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addPathType(type -> {
            type.setJdbcTypeHandler(this.getPathConverter());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
        this.getDbDataTypes().addPolygonType(type -> {
            type.setJdbcTypeHandler(this.getPolygonConverter());
            type.setSupportsArray(true);
            type.convertColumnTypeMatchers(columnTypeMatcherConverter);
        });
    }

    private JdbcTypeHandler getIntervalConverter(Converter<?> resultSetConveter) {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new PipeConverter(new Converter[]{new FromPGIntervalConverter(), resultSetConveter}));
        converter.setStatementConverter((Converter)new ToPGIntervalConverter());
        return converter;
    }

    private JdbcTypeHandler getPointConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPointConverter());
        converter.setStatementConverter((Converter)new ToPGPointConverter());
        return converter;
    }

    private JdbcTypeHandler getCircleConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGCircleConverter());
        converter.setStatementConverter((Converter)new ToPGCircleConverter());
        return converter;
    }

    private JdbcTypeHandler getBoxConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGBoxConverter());
        converter.setStatementConverter((Converter)new ToPGBoxConverter());
        return converter;
    }

    private JdbcTypeHandler getLsegConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGLsegConverter());
        converter.setStatementConverter((Converter)new ToPGLsegConverter());
        return converter;
    }

    private JdbcTypeHandler getLineConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGLineConverter());
        converter.setStatementConverter((Converter)new ToPGLineConverter());
        return converter;
    }

    private JdbcTypeHandler getPathConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPathConverter());
        converter.setStatementConverter((Converter)new ToPGPathConverter());
        return converter;
    }

    private JdbcTypeHandler getPolygonConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPolygonConverter());
        converter.setStatementConverter((Converter)new ToPGPolygonConverter());
        return converter;
    }

    public String getProductName() {
        return "PostgreSQL";
    }

    public String getSimpleName() {
        return "postgres";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select nextval ('" + sequenceName + "')";
    }

    public String getIdentitySelectString() {
        return "select lastval()";
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsDropCascade() {
        return true;
    }

    public boolean supportsColumnSequence() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsRuleOnDelete(CascadeRule rule) {
        return true;
    }

    public boolean supportsCascadeUpdate() {
        return true;
    }

    public boolean supportsRuleOnUpdate(CascadeRule rule) {
        return true;
    }

    public boolean supportsCascadeRistrict() {
        return true;
    }

    public boolean supportsDefaultValueFunction() {
        return true;
    }

    public boolean supportsFunctionOverload() {
        return true;
    }

    public boolean supportsProcedureOverload() {
        return true;
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public DefaultCase getDefaultCase() {
        return DefaultCase.LowerCase;
    }

    public String nativeCaseString(String value) {
        if (CommonUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (this.isQuoted(value)) {
            return value;
        }
        return value.toLowerCase();
    }

    public String selectRecursiveSql(Table table, boolean backTrace) {
        return null;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public CatalogReader getCatalogReader() {
        return new PostgresCatalogReader(this);
    }

    public SqlFactoryRegistry createSqlFactoryRegistry() {
        return new PostgresSqlFactoryRegistry(this);
    }

    public boolean supportsCatalog() {
        return true;
    }

    public PostgresSqlBuilder createSqlBuilder() {
        return new PostgresSqlBuilder(this);
    }

    public PostgresSqlSplitter createSqlSplitter() {
        return new PostgresSqlSplitter(this);
    }

    protected String doQuote(String target) {
        StringBuilder builder = new StringBuilder(target.length() + 2);
        builder.append(this.getOpenQuote()).append(target.replace("\"", "\"\"")).append(this.getCloseQuote());
        return builder.toString();
    }

    public PostgresJdbcHandler createJdbcHandler(SqlNode sqlNode) {
        PostgresJdbcHandler jdbcHandler = new PostgresJdbcHandler(sqlNode);
        return jdbcHandler;
    }

    public boolean isDdlRollbackable() {
        return true;
    }
}

