/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TableSpaceFileReader;
import com.sqlapp.data.db.metadata.TableSpaceReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresTableSpaceReader
extends TableSpaceReader {
    protected PostgresTableSpaceReader(Dialect dialect) {
        super(dialect);
    }

    protected List<TableSpace> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                TableSpace tableSpace = PostgresTableSpaceReader.this.createTableSpace(rs);
                result.add(tableSpace);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tableSpaces.sql");
    }

    protected TableSpace createTableSpace(ExResultSet rs) throws SQLException {
        String name = this.getString((ResultSet)rs, "spcname");
        TableSpace obj = new TableSpace(name);
        obj.setOwnerName(this.getString((ResultSet)rs, "usename"));
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        return obj;
    }

    protected TableSpaceFileReader newTableSpaceFileReader() {
        return null;
    }
}

