/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.UserReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.User;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresUserReader
extends UserReader {
    protected PostgresUserReader(Dialect dialect) {
        super(dialect);
    }

    protected List<User> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                User obj = PostgresUserReader.this.createUser(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("users.sql");
    }

    protected User createUser(ExResultSet rs) throws SQLException {
        String name = this.getString((ResultSet)rs, "usename");
        User obj = new User(name);
        obj.setPassword(this.getString((ResultSet)rs, "passwd"));
        obj.setId(this.getString((ResultSet)rs, "usesysid"));
        this.setSpecifics(rs, "usecreatedb", "createdb", (SpecificsProperty)obj);
        this.setSpecifics(rs, "usesuper", "superuser", (SpecificsProperty)obj);
        this.setSpecifics(rs, "valuntil", "valid until", (SpecificsProperty)obj);
        this.setSpecifics(rs, "useconfig", (SpecificsProperty)obj);
        return obj;
    }
}

