/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresDomainReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresFunctionReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresRuleReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresSequenceReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresTableReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresTriggerReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresTypeReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresViewReader;
import com.sqlapp.data.db.metadata.ConstantReader;
import com.sqlapp.data.db.metadata.DbLinkReader;
import com.sqlapp.data.db.metadata.DimensionReader;
import com.sqlapp.data.db.metadata.DomainReader;
import com.sqlapp.data.db.metadata.EventReader;
import com.sqlapp.data.db.metadata.ExternalTableReader;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.db.metadata.MaskReader;
import com.sqlapp.data.db.metadata.MviewLogReader;
import com.sqlapp.data.db.metadata.MviewReader;
import com.sqlapp.data.db.metadata.OperatorClassReader;
import com.sqlapp.data.db.metadata.OperatorReader;
import com.sqlapp.data.db.metadata.PackageBodyReader;
import com.sqlapp.data.db.metadata.PackageReader;
import com.sqlapp.data.db.metadata.ProcedureReader;
import com.sqlapp.data.db.metadata.RuleReader;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.SequenceReader;
import com.sqlapp.data.db.metadata.SynonymReader;
import com.sqlapp.data.db.metadata.TableLinkReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.metadata.TriggerReader;
import com.sqlapp.data.db.metadata.TypeBodyReader;
import com.sqlapp.data.db.metadata.TypeReader;
import com.sqlapp.data.db.metadata.ViewReader;
import com.sqlapp.data.db.metadata.XmlSchemaReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Setting;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class PostgresSchemaReader
extends SchemaReader {
    protected PostgresSchemaReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Schema> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Schema obj = new Schema(this.getString(rs, "schema_name"));
                obj.setCatalogName(this.getString(rs, "catalog_name"));
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("schemas.sql");
    }

    protected void setSchemaBefore(Connection connection, Schema schema) {
        Setting setting = (Setting)this.getSettings().get("lc_collate");
        if (setting != null) {
            schema.setCollation(setting.getValue());
        }
    }

    protected TableReader newTableReader() {
        return new PostgresTableReader(this.getDialect());
    }

    protected ViewReader newViewReader() {
        return new PostgresViewReader(this.getDialect());
    }

    protected MviewReader newMviewReader() {
        return null;
    }

    protected SequenceReader newSequenceReader() {
        return new PostgresSequenceReader(this.getDialect());
    }

    protected DbLinkReader newDbLinkReader() {
        return null;
    }

    protected DomainReader newDomainReader() {
        return new PostgresDomainReader(this.getDialect());
    }

    protected TypeReader newTypeReader() {
        return new PostgresTypeReader(this.getDialect());
    }

    protected TypeBodyReader newTypeBodyReader() {
        return null;
    }

    protected SynonymReader newSynonymReader() {
        return null;
    }

    protected TableLinkReader newTableLinkReader() {
        return null;
    }

    protected RuleReader newRuleReader() {
        return new PostgresRuleReader(this.getDialect());
    }

    protected FunctionReader newFunctionReader() {
        return new PostgresFunctionReader(this.getDialect());
    }

    protected ProcedureReader newProcedureReader() {
        return null;
    }

    protected PackageReader newPackageReader() {
        return null;
    }

    protected PackageBodyReader newPackageBodyReader() {
        return null;
    }

    protected TriggerReader newTriggerReader() {
        return new PostgresTriggerReader(this.getDialect());
    }

    protected ConstantReader newConstantReader() {
        return null;
    }

    protected XmlSchemaReader newXmlSchemaReader() {
        return null;
    }

    protected MviewLogReader newMviewLogReader() {
        return null;
    }

    protected OperatorReader newOperatorReader() {
        return null;
    }

    protected OperatorClassReader newOperatorClassReader() {
        return null;
    }

    protected ExternalTableReader newExternalTableReader() {
        return null;
    }

    protected EventReader newEventReader() {
        return null;
    }

    protected DimensionReader newDimensionReader() {
        return null;
    }

    protected MaskReader newMaskReader() {
        return null;
    }
}

