/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.util;

import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.jdbc.AbstractJdbc;
import com.sqlapp.jdbc.JdbcLogUtils;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.SqlNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyManager;
import org.postgresql.copy.CopyOut;
import org.postgresql.core.BaseConnection;

public class PostgresJdbcHandler
extends JdbcHandler {
    private static final Pattern COPY_DETAIL_PATTERN = Pattern.compile("\\s*COPY\\s+.*?(?<fromTo>FROM|TO)?\\s+.?(?<std>STDIN|STDOUT)?\\s+.*", 42);

    public PostgresJdbcHandler(SqlNode node) {
        super(node);
    }

    public <T extends JdbcHandler> T execute(Connection connection, ParametersContext context) throws SQLException {
        String sql = this.getNode().toString();
        Matcher matcher = COPY_DETAIL_PATTERN.matcher(sql);
        if (matcher.matches()) {
            String fromTo = matcher.group("fromTo");
            String std = matcher.group("std");
            try {
                if ("TO".equalsIgnoreCase(fromTo)) {
                    this.handleCopyOut(connection, context, std);
                } else {
                    this.handleCopyIn(connection, context, std);
                }
                return (T)((Object)this);
            }
            catch (IOException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)this.execute(connection, context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleCopyIn(Connection conn, ParametersContext context, String std) throws SQLException, IOException {
        SqlParameterCollection sqlParameters = this.createSqlParameterCollection(context);
        BaseConnection connection = conn.unwrap(BaseConnection.class);
        AbstractJdbc logConnection = conn.unwrap(AbstractJdbc.class);
        Object input = sqlParameters.getInputStream();
        CopyManager copyManager = new CopyManager(connection);
        String sql = sqlParameters.getSql();
        long start = System.currentTimeMillis();
        long result = -1L;
        try {
            if ("STDIN".equals(std)) {
                result = input instanceof Reader ? copyManager.copyIn(sql, (Reader)input) : (input instanceof InputStream ? copyManager.copyIn(sql, (InputStream)input) : copyManager.copyIn(sql, System.in));
            } else {
                CopyIn copyIn = copyManager.copyIn(sql);
                result = copyIn.getHandledRowCount();
            }
            JdbcLogUtils.info((AbstractJdbc)logConnection, (String)("rowCount=" + result));
            long l = result;
            return l;
        }
        finally {
            long end = System.currentTimeMillis();
            JdbcLogUtils.logSql((AbstractJdbc)logConnection, (String)sql, (long)start, (long)end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleCopyOut(Connection conn, ParametersContext context, String std) throws SQLException, IOException {
        SqlParameterCollection sqlParameters = this.createSqlParameterCollection(context);
        BaseConnection connection = conn.unwrap(BaseConnection.class);
        AbstractJdbc logConnection = conn.unwrap(AbstractJdbc.class);
        Object output = sqlParameters.getOutputStream();
        CopyManager copyManager = new CopyManager(connection);
        String sql = sqlParameters.getSql();
        long result = -1L;
        long start = System.currentTimeMillis();
        try {
            if ("STDOUT".equals(std)) {
                result = output instanceof Writer ? copyManager.copyOut(sql, (Writer)output) : (output instanceof OutputStream ? copyManager.copyOut(sql, (OutputStream)output) : copyManager.copyOut(sql, (OutputStream)System.out));
            } else {
                CopyOut copyOut = copyManager.copyOut(sql);
                result = copyOut.getHandledRowCount();
            }
            JdbcLogUtils.info((AbstractJdbc)logConnection, (String)("rowCount=" + result));
            long l = result;
            return l;
        }
        finally {
            long end = System.currentTimeMillis();
            if (logConnection != null) {
                JdbcLogUtils.logSql((AbstractJdbc)logConnection, (String)sql, (long)start, (long)end);
            }
        }
    }
}

