/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.IntervalDayConverter;
import com.sqlapp.data.converter.IntervalDayToHourConverter;
import com.sqlapp.data.converter.IntervalDayToMinuteConverter;
import com.sqlapp.data.converter.IntervalDayToSecondConverter;
import com.sqlapp.data.converter.IntervalHourConverter;
import com.sqlapp.data.converter.IntervalHourToMinuteConverter;
import com.sqlapp.data.converter.IntervalHourToSecondConverter;
import com.sqlapp.data.converter.IntervalMinuteConverter;
import com.sqlapp.data.converter.IntervalMinuteToSecondConverter;
import com.sqlapp.data.converter.IntervalMonthConverter;
import com.sqlapp.data.converter.IntervalSecondConverter;
import com.sqlapp.data.converter.IntervalYearConverter;
import com.sqlapp.data.converter.IntervalYearToMonthConverter;
import com.sqlapp.data.converter.PipeConverter;
import com.sqlapp.data.db.converter.postgres.FromPGBoxConverter;
import com.sqlapp.data.db.converter.postgres.FromPGCircleConverter;
import com.sqlapp.data.db.converter.postgres.FromPGIntervalConverter;
import com.sqlapp.data.db.converter.postgres.FromPGLineConverter;
import com.sqlapp.data.db.converter.postgres.FromPGLsegConverter;
import com.sqlapp.data.db.converter.postgres.FromPGPathConverter;
import com.sqlapp.data.db.converter.postgres.FromPGPointConverter;
import com.sqlapp.data.db.converter.postgres.FromPGPolygonConverter;
import com.sqlapp.data.db.converter.postgres.ToPGBoxConverter;
import com.sqlapp.data.db.converter.postgres.ToPGCircleConverter;
import com.sqlapp.data.db.converter.postgres.ToPGIntervalConverter;
import com.sqlapp.data.db.converter.postgres.ToPGLineConverter;
import com.sqlapp.data.db.converter.postgres.ToPGLsegConverter;
import com.sqlapp.data.db.converter.postgres.ToPGPathConverter;
import com.sqlapp.data.db.converter.postgres.ToPGPointConverter;
import com.sqlapp.data.db.converter.postgres.ToPGPolygonConverter;
import com.sqlapp.data.db.datatype.BlobType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.data.db.datatype.DoubleType;
import com.sqlapp.data.db.datatype.InetType;
import com.sqlapp.data.db.datatype.IntType;
import com.sqlapp.data.db.datatype.IntervalDayToHourType;
import com.sqlapp.data.db.datatype.IntervalDayToMinuteType;
import com.sqlapp.data.db.datatype.IntervalDayToSecondType;
import com.sqlapp.data.db.datatype.IntervalDayType;
import com.sqlapp.data.db.datatype.IntervalHourToMinuteType;
import com.sqlapp.data.db.datatype.IntervalHourToSecondType;
import com.sqlapp.data.db.datatype.IntervalHourType;
import com.sqlapp.data.db.datatype.IntervalMinuteToSecondType;
import com.sqlapp.data.db.datatype.IntervalMinuteType;
import com.sqlapp.data.db.datatype.IntervalMonthType;
import com.sqlapp.data.db.datatype.IntervalSecondType;
import com.sqlapp.data.db.datatype.IntervalYearToMonthType;
import com.sqlapp.data.db.datatype.IntervalYearType;
import com.sqlapp.data.db.datatype.JdbcTypeHandler;
import com.sqlapp.data.db.datatype.MoneyType;
import com.sqlapp.data.db.datatype.NumericType;
import com.sqlapp.data.db.datatype.TimeType;
import com.sqlapp.data.db.datatype.TimestampType;
import com.sqlapp.data.db.datatype.VarcharType;
import com.sqlapp.data.db.dialect.DefaultCase;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresCatalogReader;
import com.sqlapp.data.db.dialect.postgres.sql.PostgresSqlFactoryRegistry;
import com.sqlapp.data.db.dialect.postgres.util.PostgresJdbcHandler;
import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.JDBCType;
import java.util.function.Supplier;

public class Postgres
extends Dialect {
    private static final long serialVersionUID = -7843214207236066501L;

    protected Postgres(Supplier<Dialect> nextVersionDialectSupplier) {
        super(nextVersionDialectSupplier);
    }

    protected void registerDataType() {
        this.getDbDataTypes().addChar(32672L);
        this.getDbDataTypes().addVarchar(32672L);
        ((VarcharType)((VarcharType)((VarcharType)this.getDbDataTypes().addVarchar("TEXT", (long)CommonUtils.LEN_1GB).setFormats(new String[]{"TEXT\\s*"})).setCreateFormat("TEXT")).setFixedLength(true)).setDefaultLength((Number)CommonUtils.LEN_1GB);
        ((BlobType)this.getDbDataTypes().addBlob("BYTEA", (long)CommonUtils.LEN_1GB).setCreateFormat("BYTEA")).setLiteral("decode('", "', 'hex')");
        this.getDbDataTypes().addBoolean("BOOL");
        this.getDbDataTypes().addBinary("BIT", (long)CommonUtils.LEN_1GB).setLiteral("decode('", "', 'hex')");
        this.getDbDataTypes().addVarBinary("VARBIT", (long)CommonUtils.LEN_1GB).setLiteral("decode('", "', 'hex')");
        this.getDbDataTypes().addSmallInt().addFormats(new String[]{"INT2"});
        ((IntType)this.getDbDataTypes().addInt().addFormats(new String[]{"INT4"})).addFormats(new String[]{"INTEGER"});
        this.getDbDataTypes().addBigInt().addFormats(new String[]{"INT8"});
        this.getDbDataTypes().addSerial("SERIAL");
        this.getDbDataTypes().addBigSerial("BIGSERIAL");
        this.getDbDataTypes().addNumeric().setMaxPrecision(Integer.valueOf(1000)).setMaxScale(Integer.valueOf(1000));
        this.getDbDataTypes().addUUID("UUID").setLiteral("{", "}");
        this.getDbDataTypes().addReal("FLOAT4");
        ((DoubleType)this.getDbDataTypes().addDouble().addFormats(new String[]{"DOUBLE PRECISION"})).addFormats(new String[]{"FLOAT8"});
        ((MoneyType)((MoneyType)((MoneyType)this.getDbDataTypes().addMoney("MONEY").setLiteral("", "::text::money")).setSurrogateType(new NumericType().setMaxPrecision(Integer.valueOf(17)).setScale(2))).setFixedPrecision(false)).setFixedScale(false);
        this.getDbDataTypes().addSqlXml("XML").setLiteral("XML '", "'");
        this.getDbDataTypes().addSmallDateTime("abstime").setDefaultValueLiteral(this.getCurrentDateFunction());
        this.getDbDataTypes().addDate().setDefaultValueLiteral(this.getCurrentDateFunction());
        this.getDbDataTypes().addTime().setDefaultValueLiteral(this.getCurrentTimeFunction());
        ((TimeType)this.getDbDataTypes().addTimeWithTimeZone("TIMETZ").setDefaultPrecision(Integer.valueOf(6))).setDefaultValueLiteral(this.getCurrentTimeFunction());
        this.getDbDataTypes().addTimestamp().setDefaultValueLiteral(this.getCurrentTimestampFunction());
        ((TimestampType)this.getDbDataTypes().addTimestampWithTimeZoneType("TIMESTAMPTZ").setDefaultPrecision(Integer.valueOf(6))).setDefaultValueLiteral(this.getCurrentTimestampFunction());
        this.getDbDataTypes().addInterval();
        ((IntervalYearType)this.getDbDataTypes().addIntervalYear().setCreateFormat("INTERVAL YAER")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalYearConverter()));
        ((IntervalMonthType)this.getDbDataTypes().addIntervalMonth().setCreateFormat("INTERVAL MONTH")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMonthConverter()));
        ((IntervalDayType)this.getDbDataTypes().addIntervalDay().setCreateFormat("INTERVAL DAY")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayConverter()));
        ((IntervalHourType)this.getDbDataTypes().addIntervalHour().setCreateFormat("INTERVAL HOUR")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourConverter()));
        ((IntervalMinuteType)this.getDbDataTypes().addIntervalMinute().setCreateFormat("INTERVAL MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMinuteConverter()));
        ((IntervalSecondType)this.getDbDataTypes().addIntervalSecond().setCreateFormat("INTERVAL SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalSecondConverter()));
        ((IntervalYearToMonthType)this.getDbDataTypes().addIntervalYearToMonth().setCreateFormat("INTERVAL YAER TO MONTH")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalYearToMonthConverter()));
        ((IntervalDayToHourType)this.getDbDataTypes().addIntervalDayToHour().setCreateFormat("INTERVAL DAY TO HOUR")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToHourConverter()));
        ((IntervalDayToMinuteType)this.getDbDataTypes().addIntervalDayToMinute().setCreateFormat("INTERVAL DAY TO MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToMinuteConverter()));
        ((IntervalDayToSecondType)this.getDbDataTypes().addIntervalDayToSecond().setCreateFormat("INTERVAL DAY TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToSecondConverter()));
        ((IntervalHourToMinuteType)this.getDbDataTypes().addIntervalHourToMinute().setCreateFormat("INTERVAL HOUR TO MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourToMinuteConverter()));
        ((IntervalHourToSecondType)this.getDbDataTypes().addIntervalHourToSecond().setCreateFormat("INTERVAL HOUR TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourToSecondConverter()));
        ((IntervalMinuteToSecondType)this.getDbDataTypes().addIntervalMinuteToSecond().setCreateFormat("INTERVAL MINUTE TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMinuteToSecondConverter()));
        ((InetType)this.getDbDataTypes().addInetType().setLiteralPrefix("inet '")).setLiteralSuffix("'");
        this.getDbDataTypes().addCidrType();
        this.getDbDataTypes().addMacAddrType();
        this.getDbDataTypes().addRowId("OID");
        this.getDbDataTypes().addPointType().setJdbcTypeHandler(this.getPointConverter());
        this.getDbDataTypes().addCircleType().setJdbcTypeHandler(this.getCircleConverter());
        this.getDbDataTypes().addBoxType().setJdbcTypeHandler(this.getBoxConverter());
        this.getDbDataTypes().addLineType().setJdbcTypeHandler(this.getLineConverter());
        this.getDbDataTypes().addLsegType().setJdbcTypeHandler(this.getLsegConverter());
        this.getDbDataTypes().addPathType().setJdbcTypeHandler(this.getPathConverter());
        this.getDbDataTypes().addPolygonType().setJdbcTypeHandler(this.getPolygonConverter());
    }

    private JdbcTypeHandler getIntervalConverter(Converter<?> resultSetConveter) {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new PipeConverter(new Converter[]{new FromPGIntervalConverter(), resultSetConveter}));
        converter.setStatementConverter((Converter)new ToPGIntervalConverter());
        return converter;
    }

    private JdbcTypeHandler getPointConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPointConverter());
        converter.setStatementConverter((Converter)new ToPGPointConverter());
        return converter;
    }

    private JdbcTypeHandler getCircleConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGCircleConverter());
        converter.setStatementConverter((Converter)new ToPGCircleConverter());
        return converter;
    }

    private JdbcTypeHandler getBoxConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGBoxConverter());
        converter.setStatementConverter((Converter)new ToPGBoxConverter());
        return converter;
    }

    private JdbcTypeHandler getLsegConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGLsegConverter());
        converter.setStatementConverter((Converter)new ToPGLsegConverter());
        return converter;
    }

    private JdbcTypeHandler getLineConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGLineConverter());
        converter.setStatementConverter((Converter)new ToPGLineConverter());
        return converter;
    }

    private JdbcTypeHandler getPathConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPathConverter());
        converter.setStatementConverter((Converter)new ToPGPathConverter());
        return converter;
    }

    private JdbcTypeHandler getPolygonConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPolygonConverter());
        converter.setStatementConverter((Converter)new ToPGPolygonConverter());
        return converter;
    }

    public String getProductName() {
        return "PostgreSQL";
    }

    public String getSimpleName() {
        return "postgres";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select nextval ('" + sequenceName + "')";
    }

    public String getIdentitySelectString() {
        return "select lastval()";
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsDropCascade() {
        return true;
    }

    public boolean supportsColumnSequence() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsRuleOnDelete(CascadeRule rule) {
        return true;
    }

    public boolean supportsCascadeUpdate() {
        return true;
    }

    public boolean supportsRuleOnUpdate(CascadeRule rule) {
        return true;
    }

    public boolean supportsCascadeRistrict() {
        return true;
    }

    public boolean supportsDefaultValueFunction() {
        return true;
    }

    public boolean supportsFunctionOverload() {
        return true;
    }

    public boolean supportsProcedureOverload() {
        return true;
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public DefaultCase getDefaultCase() {
        return DefaultCase.LowerCase;
    }

    public String nativeCaseString(String value) {
        if (CommonUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (this.isQuoted(value)) {
            return value;
        }
        return value.toLowerCase();
    }

    public String selectRecursiveSql(Table table, boolean backTrace) {
        return null;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public CatalogReader getCatalogReader() {
        return new PostgresCatalogReader(this);
    }

    protected SqlFactoryRegistry createSqlFactoryRegistry() {
        return new PostgresSqlFactoryRegistry(this);
    }

    public boolean supportsCatalog() {
        return true;
    }

    public PostgresSqlBuilder createSqlBuilder() {
        return new PostgresSqlBuilder(this);
    }

    public PostgresSqlSplitter createSqlSplitter() {
        return new PostgresSqlSplitter(this);
    }

    protected String doQuote(String target) {
        StringBuilder builder = new StringBuilder(target.length() + 2);
        builder.append(this.getOpenQuote()).append(target.replace("\"", "\"\"")).append(this.getCloseQuote());
        return builder.toString();
    }

    public PostgresJdbcHandler createJdbcHandler(SqlNode sqlNode) {
        PostgresJdbcHandler jdbcHandler = new PostgresJdbcHandler(sqlNode);
        return jdbcHandler;
    }

    public boolean isDdlRollbackable() {
        return true;
    }
}

