/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.sql;

import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.sql.AbstractMergeRowFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public class Postgres95MergeRowFactory
extends AbstractMergeRowFactory<PostgresSqlBuilder> {
    protected List<SqlOperation> getOperations(Row row) {
        String def;
        List sqlList = CommonUtils.list();
        Table table = row.getTable();
        UniqueConstraint constraint = table.getConstraints().getPrimaryKeyConstraint();
        if (constraint == null) {
            constraint = (UniqueConstraint)CommonUtils.first((List)table.getConstraints().getUniqueConstraints());
        }
        if (constraint == null) {
            return super.getOperations(row);
        }
        PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.insert()).into()).space()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
        ((PostgresSqlBuilder)builder.space())._add('(');
        boolean[] first = new boolean[]{true};
        for (Column column : table.getColumns()) {
            def = this.getValueDefinitionForInsert(row, column);
            builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                ((PostgresSqlBuilder)builder.comma(!first[0])).name(column);
                first[0] = false;
            });
        }
        ((PostgresSqlBuilder)builder.space())._add(')');
        ((PostgresSqlBuilder)builder.space()).values();
        ((PostgresSqlBuilder)builder.space())._add('(');
        first[0] = true;
        for (Column column : table.getColumns()) {
            def = this.getValueDefinitionForInsert(row, column);
            builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                ((PostgresSqlBuilder)builder.comma(!first[0]))._add(def);
                first[0] = false;
            });
        }
        ((PostgresSqlBuilder)builder.space())._add(')');
        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.space()).on()).conflict().on()).constraint()).name((AbstractSchemaObject)constraint, false);
        builder._do().update();
        ((PostgresSqlBuilder)builder.space())._add('(');
        first[0] = true;
        for (Column column : table.getColumns()) {
            if (constraint.getColumns().contains(column.getName())) continue;
            def = this.getValueDefinitionForUpdate(row, column);
            builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                ((PostgresSqlBuilder)builder.comma(!first[0]))._add(def);
                first[0] = false;
            });
        }
        builder._add(')');
        this.addSql(sqlList, builder, SqlType.MERGE_ROW, (DbCommonObject)row);
        return sqlList;
    }
}

