/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.sql;

import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.sql.AbstractCreateFunctionFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public class PostgresCreateFunctionFactory
extends AbstractCreateFunctionFactory<PostgresSqlBuilder> {
    protected void addCreateObject(Function obj, PostgresSqlBuilder builder) {
        ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.create()).or()).replace();
        builder.function();
        builder.name((AbstractSchemaObject)obj);
        ((PostgresSqlBuilder)builder.space()).arguments(obj.getArguments());
        ((PostgresSqlBuilder)builder.lineBreak()).returns();
        ((PostgresSqlBuilder)builder.space())._add(obj.getReturning());
        String quate = this.getQuate(obj);
        builder.lineBreak();
        ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.as()).space())._add(quate);
        builder.lineBreak();
        builder._add(obj.getStatement());
        builder.lineBreak();
        builder._add(quate);
        if (!CommonUtils.isEmpty((CharSequence)obj.getLanguage())) {
            builder.lineBreak();
            ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.language()).space())._add(obj.getLanguage());
        }
        if (obj.getDeterministic() != null) {
            builder.lineBreak();
            if (obj.getDeterministic().booleanValue()) {
                builder.immutable();
            } else {
                builder._volatile();
            }
        } else if (obj.getStable() != null && obj.getStable().booleanValue()) {
            builder.lineBreak();
            builder.stable();
        }
        if (obj.getOnNullCall() != null) {
            builder.lineBreak();
            builder._add((EnumProperties)obj.getOnNullCall());
        }
        if (obj.getSqlSecurity() != null) {
            builder.lineBreak();
            builder._add((EnumProperties)obj.getSqlSecurity());
        }
    }

    private String getQuate(Function obj) {
        StringBuilder builder = new StringBuilder();
        for (String line : obj.getStatement()) {
            builder.append(line);
            builder.append('\n');
        }
        String text = builder.toString();
        if (!text.contains("$$")) {
            return "$$";
        }
        String name = "$" + obj.getName() + "$";
        if (!text.contains(name)) {
            return name;
        }
        int i = 0;
        while (text.contains(name = "$" + i + "$")) {
        }
        return name;
    }

    protected void addOptions(Function obj, List<SqlOperation> sqlList) {
        if (obj.getRemarks() != null) {
            PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
            ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.comment().on()).function()).space()).specificName((Routine)obj, this.getOptions().isDecorateSchemaName())).is()).sqlChar(obj.getRemarks());
            this.addSql(sqlList, builder, SqlType.SET_COMMENT, (DbCommonObject)obj);
        }
    }
}

