/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresColumnPrivilegeReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresObjectPrivilegeReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresRoleMemberReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresRoleReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresRoutinePrivilegeReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresSchemaReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresSettingReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresTableSpaceReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresUserReader;
import com.sqlapp.data.db.metadata.AssemblyReader;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.ColumnPrivilegeReader;
import com.sqlapp.data.db.metadata.DirectoryReader;
import com.sqlapp.data.db.metadata.ObjectPrivilegeReader;
import com.sqlapp.data.db.metadata.PartitionFunctionReader;
import com.sqlapp.data.db.metadata.PartitionSchemeReader;
import com.sqlapp.data.db.metadata.PublicDbLinkReader;
import com.sqlapp.data.db.metadata.PublicSynonymReader;
import com.sqlapp.data.db.metadata.RoleMemberReader;
import com.sqlapp.data.db.metadata.RolePrivilegeReader;
import com.sqlapp.data.db.metadata.RoleReader;
import com.sqlapp.data.db.metadata.RoutinePrivilegeReader;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.SettingReader;
import com.sqlapp.data.db.metadata.TableSpaceReader;
import com.sqlapp.data.db.metadata.UserPrivilegeReader;
import com.sqlapp.data.db.metadata.UserReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Setting;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresCatalogReader
extends CatalogReader {
    public PostgresCatalogReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Catalog> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Catalog obj = PostgresCatalogReader.this.createCatalog(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected Catalog createCatalog(ExResultSet rs) throws SQLException {
        Catalog obj = new Catalog(this.getString((ResultSet)rs, "datname"));
        obj.setCollation(this.getString((ResultSet)rs, "datcollate"));
        return obj;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache().getString("catalogs.sql");
        return node;
    }

    protected SchemaReader newSchemaReader() {
        return new PostgresSchemaReader(this.getDialect());
    }

    protected TableSpaceReader newTableSpaceReader() {
        return new PostgresTableSpaceReader(this.getDialect());
    }

    public String getCurrentCatalogName(Connection connection) {
        return DbUtils.getStringValue((Connection)connection, (String)"select current_database()");
    }

    protected void setCommonAfter(Connection connection, Catalog catalog) {
        Setting setting = (Setting)catalog.getSettings().get("lc_collate");
        if (setting != null) {
            catalog.setCollation(setting.getValue());
        }
    }

    protected DirectoryReader newDirectoryReader() {
        return null;
    }

    protected PartitionFunctionReader newPartitionFunctionReader() {
        return null;
    }

    protected PartitionSchemeReader newPartitionSchemeReader() {
        return null;
    }

    protected AssemblyReader newAssemblyReader() {
        return null;
    }

    protected UserReader newUserReader() {
        return new PostgresUserReader(this.getDialect());
    }

    protected RoleReader newRoleReader() {
        return new PostgresRoleReader(this.getDialect());
    }

    protected ObjectPrivilegeReader newObjectPrivilegeReader() {
        return new PostgresObjectPrivilegeReader(this.getDialect());
    }

    protected ColumnPrivilegeReader newColumnPrivilegeReader() {
        return new PostgresColumnPrivilegeReader(this.getDialect());
    }

    protected UserPrivilegeReader newUserPrivilegeReader() {
        return null;
    }

    protected RoleMemberReader newRoleMemberReader() {
        return new PostgresRoleMemberReader(this.getDialect());
    }

    protected RoutinePrivilegeReader newRoutinePrivilegeReader() {
        return new PostgresRoutinePrivilegeReader(this.getDialect());
    }

    protected RolePrivilegeReader newRolePrivilegeReader() {
        return null;
    }

    protected SettingReader newSettingReader() {
        return new PostgresSettingReader(this.getDialect());
    }

    protected PublicDbLinkReader newPublicDbLinkReader() {
        return null;
    }

    protected PublicSynonymReader newPublicSynonymReader() {
        return null;
    }
}

