/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class PostgresCheckConstraintReader
extends CheckConstraintReader {
    public PostgresCheckConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<CheckConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        final TripleKeyMap colMap = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String schema_name = this.getString(rs, "constraint_schema");
                String table_name = this.getString(rs, "table_name");
                String constraint_name = this.getString(rs, "constraint_name");
                String expression = this.getString(rs, "consrc");
                CheckConstraint c = (CheckConstraint)map.get((Object)schema_name, (Object)table_name, (Object)constraint_name);
                List columnList = (List)colMap.get((Object)schema_name, (Object)table_name, (Object)constraint_name);
                if (c == null) {
                    c = new CheckConstraint(constraint_name, expression, new Column[0]);
                    columnList = CommonUtils.list();
                    c.setSchemaName(schema_name);
                    c.setTableName(table_name);
                    c.setDeferrability(Deferrability.getDeferrability((boolean)rs.getBoolean("is_deferrable"), (boolean)rs.getBoolean("initially_deferred")));
                    colMap.put((Object)schema_name, (Object)table_name, (Object)constraint_name, (Object)columnList);
                    map.put((Object)schema_name, (Object)table_name, (Object)constraint_name, (Object)c);
                }
                Column column = new Column(this.getString(rs, "column_name"));
                column.setTableName(table_name);
                columnList.add(column);
            }
        });
        for (CheckConstraint c : map.toList()) {
            List columnList = (List)colMap.get((Object)c.getSchemaName(), (Object)c.getTableName(), (Object)c.getName());
            if (columnList.size() != 1) continue;
            c.setColumns(columnList.toArray(new Column[0]));
        }
        return map.toList();
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("checkConstraints.sql");
    }
}

