/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TriggerReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Trigger;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresTriggerReader
extends TriggerReader {
    protected PostgresTriggerReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Trigger> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Trigger trigger = PostgresTriggerReader.this.createTrigger(rs);
                result.add(trigger);
            }
        });
        return result;
    }

    protected Trigger createTrigger(ExResultSet rs) throws SQLException {
        Trigger obj = new Trigger(this.getString((ResultSet)rs, "trigger_name"));
        obj.setDialect(this.getDialect());
        obj.setSpecificName(this.getString((ResultSet)rs, "oid"));
        obj.setSchemaName(this.getString((ResultSet)rs, "trigger_schema"));
        obj.setActionOrientation(this.getString((ResultSet)rs, "action_orientation"));
        obj.setActionTiming(this.getString((ResultSet)rs, "condition_timing"));
        obj.setStatement(this.getString((ResultSet)rs, "action_statement"));
        obj.addEventManipulation(new String[]{this.getString((ResultSet)rs, "is_insert")});
        obj.addEventManipulation(new String[]{this.getString((ResultSet)rs, "is_update")});
        obj.addEventManipulation(new String[]{this.getString((ResultSet)rs, "is_delete")});
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        obj.setEnable(!"D".equalsIgnoreCase(this.getString((ResultSet)rs, "tgenabled")));
        return obj;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("triggers.sql");
    }
}

