/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect;

import com.sqlapp.data.db.datatype.BlobType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlite.util.SqliteSqlSplitter;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.util.function.Supplier;

public class Sqlite
extends Dialect {
    private static final long serialVersionUID = 3804986124610623903L;

    protected Sqlite(Supplier<Dialect> nextVersionDialectSupplier) {
        super(nextVersionDialectSupplier);
    }

    protected void registerDataType() {
        this.getDbDataTypes().addVarchar("TEXT", CommonUtils.LEN_2GB).setCreateFormat("TEXT");
        ((BlobType)this.getDbDataTypes().addBlob("BLOB", CommonUtils.LEN_2GB).setCreateFormat("BLOB")).setLiteral("X'", "'");
        this.getDbDataTypes().addBoolean();
        this.getDbDataTypes().addTinyInt("INTEGER");
        this.getDbDataTypes().addSmallInt("INTEGER");
        this.getDbDataTypes().addInt("INTEGER");
        this.getDbDataTypes().addBigInt("INTEGER");
        this.getDbDataTypes().addUUID("BLOB");
        this.getDbDataTypes().addDouble("REAL");
        this.getDbDataTypes().addNumeric();
    }

    public String getProductName() {
        return "SQLite";
    }

    public String getSimpleName() {
        return "sqlite";
    }

    public boolean supportsTop() {
        return true;
    }

    public String getIdentitySelectString() {
        return "select last_insert_rowid()";
    }

    public boolean supportsIdentity() {
        return true;
    }

    public char getCloseQuote() {
        return ']';
    }

    public char getOpenQuote() {
        return '[';
    }

    public String getCurrentDateFunction() {
        return null;
    }

    public String getCurrentDateTimeFunction() {
        return null;
    }

    public String getCurrentTimestampFunction() {
        return null;
    }

    public String getCurrentTimestampWithTimeZoneFunction() {
        return null;
    }

    public String getCurrentTimeFunction() {
        return null;
    }

    public boolean supportsDropCascade() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsRuleOnDelete(CascadeRule rule) {
        return true;
    }

    public boolean supportsCascadeUpdate() {
        return true;
    }

    public boolean supportsRuleOnUpdate(CascadeRule rule) {
        return true;
    }

    public boolean supportsDefaultValueFunction() {
        return false;
    }

    public String selectRecursiveSql(Table table, boolean backTrace) {
        return null;
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public SqliteSqlSplitter createSqlSplitter() {
        return new SqliteSqlSplitter(this);
    }
}

