/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005ColumnReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005IndexReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.ViewReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.View;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005ViewReader
extends ViewReader {
    protected SqlServer2005ViewReader(Dialect dialect) {
        super(dialect);
    }

    protected ColumnReader newColumnReader() {
        return new SqlServer2005ColumnReader(this.getDialect());
    }

    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table table = SqlServer2005ViewReader.this.createTable(rs);
                result.add(table);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("views2005.sql");
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        View obj = super.createTable(this.getString((ResultSet)rs, "table_name"));
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setCreatedAt(rs.getTimestamp("create_date"));
        obj.setLastAlteredAt(rs.getTimestamp("modify_date"));
        String difinition = this.getString((ResultSet)rs, "definition");
        if (this.getReaderOptions().isReadDefinition()) {
            obj.setDefinition(difinition);
        }
        if (this.getReaderOptions().isReadStatement()) {
            obj.setStatement(SqlServerUtils.getViewStatement((String)difinition));
        }
        this.setSpecifics(rs, "is_schema_bound", (SpecificsProperty)obj);
        this.setSpecifics(rs, "with_check_option", (SpecificsProperty)obj);
        return obj;
    }

    protected IndexReader newIndexReader() {
        return new SqlServer2005IndexReader(this.getDialect());
    }

    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

