/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000TableReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005CheckConstraintReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005ColumnReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005ForeignKeyConstraintReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005IndexReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005UniqueConstraintReader;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005TableReader
extends SqlServer2000TableReader {
    protected SqlServer2005TableReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final DoubleKeyMap result = new DoubleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table table = SqlServer2005TableReader.this.createTable(rs);
                result.put((Object)table.getSchemaName(), (Object)table.getName(), (Object)table);
            }
        });
        return result.toList();
    }

    protected void setMetadataDetail(Connection connection, ParametersContext context, List<Table> obj) throws SQLException {
        super.setMetadataDetail(connection, context, obj);
        if (CommonUtils.isEmpty(obj)) {
            return;
        }
        DoubleKeyMap tableMap = new DoubleKeyMap();
        for (Table table : obj) {
            tableMap.put((Object)table.getSchemaName(), (Object)table.getName(), (Object)table);
        }
        this.setPartitioning(connection, (DoubleKeyMap<String, String, Table>)tableMap);
    }

    protected void setPartitioning(Connection connection, final DoubleKeyMap<String, String, Table> tableMap) {
        SqlNode node = this.getSqlNodeCache().getString("partitionColumns2005.sql");
        ParametersContext context = new ParametersContext();
        context.put("schema_name", (Object)tableMap.keySet());
        context.put("table_name", (Object)tableMap.secondKeySet());
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String schemaName = rs.getString("schema_name");
                String tableName = rs.getString("table_name");
                String columnName = rs.getString("column_name");
                Table table = (Table)tableMap.get((Object)schemaName, (Object)tableName);
                if (table != null) {
                    Column column = (Column)table.getColumns().get(columnName);
                    ReferenceColumn rcolumn = new ReferenceColumn(column);
                    table.getPartitioning().getPartitioningColumns().add((AbstractNamedObject)rcolumn);
                }
            }
        });
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tables2005.sql");
    }

    @Override
    protected Table createTable(ExResultSet rs) throws SQLException {
        Table table = super.createTable(rs);
        table.setLastAlteredAt(rs.getTimestamp("modify_date"));
        String partitionScheme = this.getString((ResultSet)rs, "partition_scheme");
        if (!CommonUtils.isEmpty((CharSequence)partitionScheme)) {
            ((Table)table.toPartitioning()).getPartitioning().setPartitionSchemeName(partitionScheme);
            table.setTableSpace((TableSpace)null);
        }
        this.setSpecifics(rs, "large_value_types_out_of_row", (SpecificsProperty)table);
        this.setSpecifics(rs, "has_var_decimal", (SpecificsProperty)table);
        return table;
    }

    @Override
    protected ColumnReader newColumnReader() {
        return new SqlServer2005ColumnReader(this.getDialect());
    }

    @Override
    protected IndexReader newIndexReader() {
        return new SqlServer2005IndexReader(this.getDialect());
    }

    @Override
    protected UniqueConstraintReader newUniqueConstraintReader() {
        return new SqlServer2005UniqueConstraintReader(this.getDialect());
    }

    @Override
    protected CheckConstraintReader newCheckConstraintReader() {
        return new SqlServer2005CheckConstraintReader(this.getDialect());
    }

    @Override
    protected ForeignKeyConstraintReader newForeignKeyConstraintReader() {
        return new SqlServer2005ForeignKeyConstraintReader(this.getDialect());
    }
}

