/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000IndexReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005FullTextIndexReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005IndexReader
extends SqlServer2000IndexReader {
    public SqlServer2005IndexReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Index> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String name;
                String schema_name;
                String catalog_name = this.getString(rs, "catalog_name");
                Index index = (Index)map.get((Object)catalog_name, (Object)(schema_name = this.getString(rs, "schema_name")), (Object)(name = this.getString(rs, "index_name")));
                if (index == null) {
                    index = SqlServer2005IndexReader.this.createIndex(rs);
                    map.put((Object)catalog_name, (Object)schema_name, (Object)name, (Object)index);
                }
                String columnName = this.getString(rs, "column_name");
                boolean included = SqlServer2005IndexReader.this.getBoolean((ResultSet)rs, "is_included_column");
                if (included) {
                    index.getIncludes().add(new Column(columnName));
                } else if (rs.getInt("is_descending_key") == 1) {
                    index.getColumns().add(new Column(columnName), Order.Desc);
                } else {
                    index.getColumns().add(new Column(columnName), Order.Asc);
                }
            }
        });
        List result = map.toList();
        List<Index> fullTextResult = this.getMetadataFullTextIndex(connection, context, productVersionInfo);
        result.addAll(fullTextResult);
        return result;
    }

    protected List<Index> getMetadataFullTextIndex(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        IndexReader reader = this.getFullTextIndexReader();
        return reader.getAll(connection, context);
    }

    protected IndexReader getFullTextIndexReader() {
        IndexReader reader = this.newFullTextIndexReader();
        this.initializeChild((MetadataReader)reader);
        return reader;
    }

    protected IndexReader newFullTextIndexReader() {
        SqlServer2005FullTextIndexReader reader = new SqlServer2005FullTextIndexReader(this.getDialect());
        return reader;
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("indexes2005.sql");
    }

    @Override
    protected Index createIndex(ExResultSet rs) throws SQLException {
        Index index = super.createIndex(rs);
        return index;
    }
}

