/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.NVarcharType;
import com.sqlapp.data.db.datatype.VarBinaryType;
import com.sqlapp.data.db.datatype.VarcharType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2000;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005CatalogReader;
import com.sqlapp.data.db.dialect.sqlserver.sql.SqlServer2005SqlFactoryRegistry;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.util.CommonUtils;
import java.util.function.Supplier;

public class SqlServer2005
extends SqlServer2000 {
    private static final long serialVersionUID = -6574415406411255507L;

    protected SqlServer2005(Supplier<Dialect> nextVersionDialectSupplier) {
        super(nextVersionDialectSupplier);
    }

    @Override
    protected void registerDataType() {
        super.registerDataType();
        ((VarcharType)((VarcharType)((VarcharType)this.getDbDataTypes().addVarchar(CommonUtils.LEN_2GB).addFormats(new String[]{"VARCHAR\\s*\\(\\s*MAX\\s*\\)"})).setDefaultLength(Long.valueOf(CommonUtils.LEN_2GB))).setCreateFormat("VARCHAR(MAX)")).setFixedLength(false);
        ((NVarcharType)((NVarcharType)((NVarcharType)this.getDbDataTypes().addNVarchar((long)CommonUtils.LEN_1GB).addFormats(new String[]{"NVARCHAR\\s*\\(\\s*MAX\\s*\\)"})).setDefaultLength((Number)CommonUtils.LEN_1GB)).setCreateFormat("NVARCHAR(MAX)")).setFixedLength(false);
        ((VarBinaryType)((VarBinaryType)((VarBinaryType)((VarBinaryType)((VarBinaryType)((VarBinaryType)this.getDbDataTypes().addVarBinary(CommonUtils.LEN_2GB).setDefaultLength(Long.valueOf(CommonUtils.LEN_2GB))).addFormats(new String[]{"VARBINARY\\s*\\(\\s*MAX\\s*\\)"})).setDefaultLength(Long.valueOf(CommonUtils.LEN_2GB))).addFormats(new String[]{"IMAGE"})).setCreateFormat("VARBINARY(MAX)")).setFixedLength(false)).setLiteral("0x", "");
        this.getDbDataTypes().addSqlXml("XML").setLiteral("'", "'");
    }

    @Override
    public boolean supportsWith() {
        return true;
    }

    public boolean supportsWithRecursive() {
        return true;
    }

    @Override
    public boolean supportsTop() {
        return true;
    }

    @Override
    public boolean supportsRuleOnDelete(CascadeRule rule) {
        return true;
    }

    @Override
    public boolean supportsRuleOnUpdate(CascadeRule rule) {
        return true;
    }

    @Override
    public boolean supportsSchema() {
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 1;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public CatalogReader getCatalogReader() {
        return new SqlServer2005CatalogReader(this);
    }

    @Override
    public SqlFactoryRegistry createSqlFactoryRegistry() {
        return new SqlServer2005SqlFactoryRegistry(this);
    }

    public boolean setDbType(DataType dataType, String productDataType, Long lengthOrPrecision, Integer scale, DataTypeLengthProperties<?> column) {
        boolean bool = super.setDbType(dataType, productDataType, lengthOrPrecision, scale, column);
        if (bool) {
            this.setVarcharMax(column);
        }
        return bool;
    }

    protected void setVarcharMax(DataTypeLengthProperties<?> column) {
        if (column.getDataType() == DataType.VARCHAR && column.getLength() != null && (column.getLength() > 8000L || column.getLength() < 0L)) {
            column.setLength(CommonUtils.LEN_2GB);
        }
        if (column.getDataType() == DataType.NVARCHAR && column.getLength() != null && (column.getLength() > 4000L || column.getLength() < 0L)) {
            column.setLength((long)CommonUtils.LEN_1GB);
        }
    }
}

