/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.util;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.dialect.util.SqlTokenizer;
import com.sqlapp.data.db.dialect.util.StringHolder;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.regex.Pattern;

public class SqlServerSqlSplitter
extends SqlSplitter {
    private static final Pattern GO_PATTERN = Pattern.compile("GO\\s*(?<itr>[0-9]+)?\\s*", 2);
    private int previousGoPosition = 0;
    private Integer itrCount = null;
    private boolean go = false;

    public SqlServerSqlSplitter(Dialect dialect) {
        super(dialect);
    }

    protected void handleGOIterate(StringHolder stringHolder, Integer itrCount) {
        this.itrCount = itrCount;
        this.go = true;
    }

    protected void addStatementAfter() {
        if (!this.go) {
            return;
        }
        this.go = false;
        if (this.getStatements().size() > 0 && this.itrCount != null) {
            List<SqlSplitter.SplitResult> statements = this.getIterateStatements();
            for (int i = 0; i < this.itrCount - 1; ++i) {
                this.getStatements().addAll(statements);
            }
        }
        this.itrCount = null;
        this.previousGoPosition = this.getStatements().size();
    }

    private List<SqlSplitter.SplitResult> getIterateStatements() {
        return this.getStatements().subList(this.previousGoPosition, this.getStatements().size());
    }

    protected SqlTokenizer createSqlTokenizer(String input) {
        return new SqlTokenizer(input){

            protected void handleElse(StringHolder stringHolder) {
                int pos = stringHolder.searchLineOf(GO_PATTERN, stringHolder.getPosition(), true, (i, matcher) -> {
                    this.handleSimpleStatement((int)i, stringHolder);
                    stringHolder.setPosition(i + matcher.group().length() + 1);
                    String val = matcher.group("itr");
                    if (!CommonUtils.isEmpty((CharSequence)val)) {
                        Integer itrCount = Integer.valueOf(val);
                        SqlServerSqlSplitter.this.handleGOIterate(stringHolder, itrCount);
                    } else {
                        SqlServerSqlSplitter.this.handleGOIterate(stringHolder, null);
                    }
                    return true;
                });
                if (pos < 0) {
                    this.setPosition(pos);
                }
            }
        };
    }
}

