/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.sql;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.dialect.sqlserver.sql.SqlServer2005CreateTableFactory;
import com.sqlapp.data.db.dialect.sqlserver.util.SqlServerIndexOptions;
import com.sqlapp.data.db.dialect.sqlserver.util.SqlServerSqlBuilder;
import com.sqlapp.data.schemas.DbInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.OnOffType;

public class SqlServer2008CreateTableFactory
extends SqlServer2005CreateTableFactory {
    @Override
    protected void addOption(Table table, SqlServerSqlBuilder builder) {
        super.addOption(table, builder);
        DbInfo map = table.getSpecifics();
        if (table.isCompression()) {
            builder.lineBreak();
            ((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.with()).space()).brackets(() -> {
                ((SqlServerSqlBuilder)builder.dataCompression().eq()).space();
                if ("ROW".equalsIgnoreCase(table.getCompressionType())) {
                    builder.row();
                } else if ("PAGE".equalsIgnoreCase(table.getCompressionType())) {
                    builder.page();
                } else if ("COLUMNSTORE".equalsIgnoreCase(table.getCompressionType())) {
                    builder.columnstore();
                } else if ("COLUMNSTORE_ARCHIVE".equalsIgnoreCase(table.getCompressionType())) {
                    builder.columnstoreArchive();
                } else {
                    builder.row();
                }
                this.addWithOption(table, builder);
            });
        } else {
            SqlServerSqlBuilder child = builder.newInstance();
            this.addWithOption(table, child);
            if (!child.toString().isEmpty()) {
                ((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.with()).space()).brackets(() -> {
                    builder.space();
                    builder._add(child.toString());
                });
            }
        }
        Boolean val = (Boolean)Converters.getDefault().convertObject(map.get("HAS_CHANGE_TRACKING"), Boolean.class);
        if (val != null) {
            builder.lineBreak();
            if (val.booleanValue()) {
                builder.enable().changeTracking();
            } else {
                builder.lineBreak();
                builder.disable().changeTracking();
            }
        }
    }

    protected void addWithOption(Table table, SqlServerSqlBuilder builder) {
        DbInfo map = table.getSpecifics();
        boolean[] first = new boolean[]{true};
        map.forEach((k, v) -> {
            SqlServerIndexOptions enm;
            if ("HAS_CHANGE_TRACKING".equalsIgnoreCase((String)k)) {
                return;
            }
            if (!first[0]) {
                ((SqlServerSqlBuilder)builder.space()).comma();
            }
            if ((enm = SqlServerIndexOptions.parse(k)) != null) {
                builder._add((Object)enm);
                first[0] = false;
                if (CommonUtils.isEmpty((CharSequence)v)) {
                    return;
                }
                ((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.space()).eq()).space();
                if (enm.isOnOff()) {
                    OnOffType onOffType = OnOffType.parse((Object)k, null);
                    if (onOffType == null) {
                        builder._add(enm.getDefaultValue());
                    } else {
                        builder._add(onOffType);
                    }
                } else {
                    builder._add((String)v);
                }
            } else {
                builder._add(k.toUpperCase());
                first[0] = false;
                if (CommonUtils.isEmpty((CharSequence)v)) {
                    return;
                }
                ((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.space()).eq()).space();
                builder._add((String)v);
            }
        });
    }
}

