/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionReturning;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class SqlServer2000FunctionReader
extends FunctionReader {
    protected SqlServer2000FunctionReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Function> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Function routine = SqlServer2000FunctionReader.this.createFunction(rs);
                result.add(routine);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache().getString("functions2000.sql");
        return node;
    }

    protected Function createFunction(ExResultSet rs) throws SQLException {
        Timestamp created = rs.getTimestamp("created");
        Timestamp lastAltered = rs.getTimestamp("last_altered");
        Function obj = new Function(this.getString((ResultSet)rs, "routine_name"));
        obj.setSpecificName(this.getString((ResultSet)rs, "specific_name"));
        obj.setCatalogName(this.getString((ResultSet)rs, "specific_catalog"));
        obj.setSchemaName(this.getString((ResultSet)rs, "specific_schema"));
        obj.setCreatedAt(created);
        obj.setLastAlteredAt(lastAltered);
        String definition = this.getString((ResultSet)rs, "routine_definition");
        if (this.getReaderOptions().isReadDefinition()) {
            obj.setDefinition(definition);
        }
        FunctionReturning ret = obj.getReturning();
        String productDataType = SqlServerUtils.getFunctionReturnName(definition);
        this.getDialect().setDbType(productDataType, null, null, (DataTypeLengthProperties)ret);
        return obj;
    }

    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return null;
    }
}

