/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TableSpaceFileReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.TableSpaceFile;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2000TableSpaceFileReader
extends TableSpaceFileReader {
    protected SqlServer2000TableSpaceFileReader(Dialect dialect) {
        super(dialect);
    }

    protected List<TableSpaceFile> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                TableSpaceFile obj = SqlServer2000TableSpaceFileReader.this.createStorageFile(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tableSpaceFiles2000.sql");
    }

    protected TableSpaceFile createStorageFile(ExResultSet rs) throws SQLException {
        TableSpaceFile obj = new TableSpaceFile(this.getString((ResultSet)rs, "name"), this.getString((ResultSet)rs, "physical_name"));
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setTableSpaceName(this.getString((ResultSet)rs, "file_group_name"));
        obj.setAutoExtensible(rs.getInt("growth") > 0);
        this.setSpecifics((ResultSet)rs, "file_id", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "size", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "growth", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "max_size", (SpecificsProperty)obj);
        return obj;
    }
}

