/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SequenceReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2012SequenceReader
extends SequenceReader {
    protected SqlServer2012SequenceReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Sequence> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Sequence sequence = SqlServer2012SequenceReader.this.createSequence(rs);
                result.add(sequence);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("sequences2012.sql");
    }

    protected Sequence createSequence(ExResultSet rs) throws SQLException {
        Sequence obj = new Sequence(this.getString((ResultSet)rs, "sequence_name"));
        obj.setDialect(this.getDialect());
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setDataTypeName(this.getString((ResultSet)rs, "type_name"));
        obj.setLastValue((Number)rs.getBigDecimal("current_value"));
        obj.setStartValue((Number)rs.getBigDecimal("start_value"));
        obj.setIncrementBy((Number)rs.getBigDecimal("increment"));
        obj.setMinValue((Number)rs.getBigDecimal("minimum_value"));
        obj.setMaxValue((Number)rs.getBigDecimal("maximum_value"));
        obj.setCycle(rs.getBoolean("is_cycling"));
        obj.setCache(rs.getBoolean("is_cached"));
        obj.setPrecision((Number)this.getInteger((ResultSet)rs, "precision"));
        obj.setScale((Number)this.getInteger((ResultSet)rs, "scale"));
        obj.setCacheSize((Number)rs.getBigDecimal("cache_size"));
        obj.setCreatedAt(rs.getTimestamp("create_date"));
        obj.setLastAlteredAt(rs.getTimestamp("modify_date"));
        return obj;
    }
}

