/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005TableReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2008IndexReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.node.SqlNode;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlServer2008TableReader
extends SqlServer2005TableReader {
    protected SqlServer2008TableReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tables2008.sql");
    }

    @Override
    protected Table createTable(ExResultSet rs) throws SQLException {
        Table table = super.createTable(rs);
        table.setCompression(this.getBoolean((ResultSet)rs, "data_compression").booleanValue());
        String compType = this.getString((ResultSet)rs, "data_compression_desc");
        if (!"NONE".equalsIgnoreCase(compType)) {
            table.setCompressionType(compType);
        }
        this.setSpecifics(rs, "lock_escalation", (SpecificsProperty)table);
        this.setSpecifics(rs, "is_track_columns_updated_on", (SpecificsProperty)table);
        this.setSpecifics(rs, "has_change_tracking", (SpecificsProperty)table);
        return table;
    }

    @Override
    protected IndexReader newIndexReader() {
        return new SqlServer2008IndexReader(this.getDialect());
    }
}

