/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.sql;

import com.sqlapp.data.db.dialect.sqlserver.util.SqlServerSqlBuilder;
import com.sqlapp.data.db.sql.AbstractCreateIndexFactory;
import com.sqlapp.data.db.sql.AddTableObjectDetailFactory;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.util.Map;

public class SqlServerCreateIndexFactory
extends AbstractCreateIndexFactory<SqlServerSqlBuilder>
implements AddTableObjectDetailFactory<Index, SqlServerSqlBuilder> {
    public void addObjectDetail(Index obj, Table table, SqlServerSqlBuilder builder) {
        builder.unique(obj.isUnique());
        this.addIndexType(obj, table, builder);
        ((SqlServerSqlBuilder)builder.index()).space();
        if (table != null) {
            builder.name(obj, this.getOptions().isDecorateSchemaName());
        } else {
            builder.name(obj, false);
        }
        if (table != null) {
            builder.on();
            builder.name((AbstractSchemaObject)table);
        }
        ((SqlServerSqlBuilder)builder.space())._add("(");
        builder.names(obj.getColumns());
        ((SqlServerSqlBuilder)builder.space())._add(")");
        this.addObjectDetailAfter(obj, table, builder);
    }

    protected void addIndexType(Index obj, Table table, SqlServerSqlBuilder builder) {
        if (obj.getIndexType() != null && obj.getIndexType().isClusterd()) {
            builder.clustered();
        }
    }

    protected void addObjectDetailAfter(Index obj, Table table, SqlServerSqlBuilder builder) {
        this.addIndexWithOption(obj, table, builder);
    }

    protected void addIndexWithOption(Index obj, Table table, SqlServerSqlBuilder builder) {
        Map<String, String> map = this.createIndexWithOption(obj, table);
        if (!map.isEmpty()) {
            builder.lineBreak();
            ((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.with()).space()).brackets(() -> {
                builder.indent(() -> {
                    boolean[] first = new boolean[]{true};
                    map.forEach((k, v) -> {
                        ((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.lineBreak()).comma(!first[0]))._add((String)k)).eq()).space())._add((String)v);
                        first[0] = false;
                    });
                });
                builder.lineBreak();
            });
        }
    }

    protected Map<String, String> createIndexWithOption(Index obj, Table table) {
        Map map = CommonUtils.linkedMap();
        String key = "PAD_INDEX";
        String val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        key = "fill_factor";
        val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put("FILLFACTOR", val);
        } else {
            val = obj.getSpecifics().get("FILLFACTOR");
            if (val != null) {
                map.put("FILLFACTOR", val);
            }
        }
        key = "ALLOW_ROW_LOCKS";
        val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        key = "ALLOW_PAGE_LOCKS";
        val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        return map;
    }
}

