/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2000CheckConstraintReader
extends CheckConstraintReader {
    protected SqlServer2000CheckConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<CheckConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String catalog_name = this.getString(rs, "catalog_name");
                String schema_name = this.getString(rs, "schema_name");
                String constraint_name = this.getString(rs, "constraint_name");
                String columnName = this.getString(rs, "column_name");
                CheckConstraint c = (CheckConstraint)map.get((Object)catalog_name, (Object)schema_name, (Object)constraint_name);
                if (c == null) {
                    c = SqlServer2000CheckConstraintReader.this.createCheckConstraint(rs);
                    map.put((Object)catalog_name, (Object)schema_name, (Object)constraint_name, (Object)c);
                } else {
                    String definition = SqlServerUtils.replaceNames(c.getExpression(), columnName);
                    c.setExpression(definition);
                }
                Column column = new Column(columnName);
                column.setTableName(c.getTableName());
                c.addColumns(new Column[]{column});
            }
        });
        List list = map.toList();
        return list;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("checkConstraints2000.sql");
    }

    protected CheckConstraint createCheckConstraint(ExResultSet rs) throws SQLException {
        boolean isColumnConstraint;
        String constraint_name = this.getString((ResultSet)rs, "constraint_name");
        String columnName = this.getString((ResultSet)rs, "column_name");
        String tableName = this.getString((ResultSet)rs, "table_name");
        String schemaName = this.getString((ResultSet)rs, "schema_name");
        String definition = SqlServerUtils.replaceNames(CommonUtils.unwrap((String)this.getString((ResultSet)rs, "definition"), (char)'(', (char)')'), columnName);
        CheckConstraint c = new CheckConstraint(constraint_name, definition, new Column[0]);
        c.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        c.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        c.setTableName(tableName);
        boolean bl = isColumnConstraint = rs.getInt("is_column_check_constraint") == 1;
        if (isColumnConstraint) {
            Column column = new Column(columnName);
            column.setTableName(tableName);
            column.setSchemaName(schemaName);
            c.addColumns(new Column[]{column});
        }
        return c;
    }
}

