/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.ProcedureReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class SqlServer2000ProcedureReader
extends ProcedureReader {
    protected SqlServer2000ProcedureReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Procedure> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Procedure procedure = SqlServer2000ProcedureReader.this.createProcedure(rs);
                result.add(procedure);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache().getString("procedures2000.sql");
        return node;
    }

    protected Procedure createProcedure(ExResultSet rs) throws SQLException {
        Timestamp created = rs.getTimestamp("created");
        Timestamp lastAltered = rs.getTimestamp("last_altered");
        Procedure obj = new Procedure(this.getString((ResultSet)rs, "routine_name"));
        obj.setSpecificName(this.getString((ResultSet)rs, "specific_name"));
        obj.setCatalogName(this.getString((ResultSet)rs, "specific_catalog"));
        obj.setSchemaName(this.getString((ResultSet)rs, "specific_schema"));
        obj.setCreatedAt(created);
        obj.setLastAlteredAt(lastAltered);
        String difinition = this.getString((ResultSet)rs, "routine_definition");
        if (this.getReaderOptions().isReadDefinition()) {
            obj.setDefinition(difinition);
        }
        if (this.getReaderOptions().isReadStatement()) {
            obj.setStatement(SqlServerUtils.getViewStatement((String)difinition));
        }
        return obj;
    }

    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return null;
    }
}

