/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.collect;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;

public class SynchronizedEvictingQueue<E>
implements Queue<E> {
    private final int maxSize;
    private final Queue<E> deque;

    public SynchronizedEvictingQueue(int maxSize) {
        Preconditions.checkArgument((0 < maxSize ? 1 : 0) != 0);
        this.maxSize = maxSize;
        this.deque = new ArrayDeque(maxSize);
    }

    @Override
    public synchronized int size() {
        return this.deque.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.deque.contains(o);
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return this.deque.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.deque.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.deque.toArray(a);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.deque.remove(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.deque.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        Preconditions.checkNotNull(c);
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.deque.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.deque.retainAll(c);
    }

    @Override
    public synchronized void clear() {
        this.deque.clear();
    }

    @Override
    public synchronized boolean add(E e) {
        Preconditions.checkNotNull(e);
        if (this.deque.size() == this.maxSize) {
            this.deque.remove();
        }
        this.deque.add(e);
        return true;
    }

    @Override
    public synchronized boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public synchronized E remove() {
        return this.deque.remove();
    }

    @Override
    public synchronized E poll() {
        return this.deque.poll();
    }

    @Override
    public synchronized E element() {
        return this.deque.element();
    }

    @Override
    public synchronized E peek() {
        return this.deque.peek();
    }
}

