/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.socket;

import com.stackify.api.common.socket.UnixConnectionSocketFactory;
import lombok.NonNull;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpSocketClient {
    private final HttpClientConnectionManager httpClientConnectionManager;

    public HttpSocketClient(@NonNull String socketPath) {
        if (socketPath == null) {
            throw new NullPointerException("socketPath is marked non-null but is null");
        }
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("unix", (Object)new UnixConnectionSocketFactory(socketPath));
        Registry registry = registryBuilder.build();
        this.httpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(@NonNull HttpPost httpPost) throws Exception {
        if (httpPost == null) {
            throw new NullPointerException("httpPost is marked non-null but is null");
        }
        try (CloseableHttpClient client = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).setConnectionManager(this.httpClientConnectionManager).setConnectionManagerShared(true).build();){
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)httpPost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(@NonNull HttpGet httpGet) throws Exception {
        if (httpGet == null) {
            throw new NullPointerException("httpGet is marked non-null but is null");
        }
        try (CloseableHttpClient client = HttpClients.custom().setConnectionManager(this.httpClientConnectionManager).build();){
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)httpGet);
        }
    }
}

