/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Job {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * Code of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("code")
    private JsonNullable<String> code;

    /**
     * Title of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private JsonNullable<String> title;

    /**
     * Status of the job
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    @Deprecated
    private JsonNullable<String> status;

    /**
     * Status of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job_status")
    private JsonNullable<? extends JobStatus> jobStatus;

    /**
     * Department ids of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("department_ids")
    private JsonNullable<? extends List<String>> departmentIds;

    /**
     * Provider's department ids of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_department_ids")
    private JsonNullable<? extends List<String>> remoteDepartmentIds;

    /**
     * Location ids of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location_ids")
    private JsonNullable<? extends List<String>> locationIds;

    /**
     * Provider's location ids of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_location_ids")
    private JsonNullable<? extends List<String>> remoteLocationIds;

    /**
     * Hiring team for the job.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("hiring_team")
    private JsonNullable<? extends List<JobHiringTeam>> hiringTeam;

    /**
     * Interview stages for the job.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interview_stages")
    private JsonNullable<? extends List<InterviewStage>> interviewStages;

    /**
     * Confidential status of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("confidential")
    private JsonNullable<? extends JobConfidential> confidential;

    /**
     * The job custom fields
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("custom_fields")
    private JsonNullable<? extends List<CustomFields>> customFields;

    /**
     * Date of creation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Date of last update
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public Job(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("code") JsonNullable<String> code,
            @JsonProperty("title") JsonNullable<String> title,
            @JsonProperty("status") JsonNullable<String> status,
            @JsonProperty("job_status") JsonNullable<? extends JobStatus> jobStatus,
            @JsonProperty("department_ids") JsonNullable<? extends List<String>> departmentIds,
            @JsonProperty("remote_department_ids") JsonNullable<? extends List<String>> remoteDepartmentIds,
            @JsonProperty("location_ids") JsonNullable<? extends List<String>> locationIds,
            @JsonProperty("remote_location_ids") JsonNullable<? extends List<String>> remoteLocationIds,
            @JsonProperty("hiring_team") JsonNullable<? extends List<JobHiringTeam>> hiringTeam,
            @JsonProperty("interview_stages") JsonNullable<? extends List<InterviewStage>> interviewStages,
            @JsonProperty("confidential") JsonNullable<? extends JobConfidential> confidential,
            @JsonProperty("custom_fields") JsonNullable<? extends List<CustomFields>> customFields,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(jobStatus, "jobStatus");
        Utils.checkNotNull(departmentIds, "departmentIds");
        Utils.checkNotNull(remoteDepartmentIds, "remoteDepartmentIds");
        Utils.checkNotNull(locationIds, "locationIds");
        Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
        Utils.checkNotNull(hiringTeam, "hiringTeam");
        Utils.checkNotNull(interviewStages, "interviewStages");
        Utils.checkNotNull(confidential, "confidential");
        Utils.checkNotNull(customFields, "customFields");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.code = code;
        this.title = title;
        this.status = status;
        this.jobStatus = jobStatus;
        this.departmentIds = departmentIds;
        this.remoteDepartmentIds = remoteDepartmentIds;
        this.locationIds = locationIds;
        this.remoteLocationIds = remoteLocationIds;
        this.hiringTeam = hiringTeam;
        this.interviewStages = interviewStages;
        this.confidential = confidential;
        this.customFields = customFields;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public Job() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * Code of the job
     */
    @JsonIgnore
    public JsonNullable<String> code() {
        return code;
    }

    /**
     * Title of the job
     */
    @JsonIgnore
    public JsonNullable<String> title() {
        return title;
    }

    /**
     * Status of the job
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> status() {
        return status;
    }

    /**
     * Status of the job
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<JobStatus> jobStatus() {
        return (JsonNullable<JobStatus>) jobStatus;
    }

    /**
     * Department ids of the job
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> departmentIds() {
        return (JsonNullable<List<String>>) departmentIds;
    }

    /**
     * Provider's department ids of the job
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteDepartmentIds() {
        return (JsonNullable<List<String>>) remoteDepartmentIds;
    }

    /**
     * Location ids of the job
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> locationIds() {
        return (JsonNullable<List<String>>) locationIds;
    }

    /**
     * Provider's location ids of the job
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteLocationIds() {
        return (JsonNullable<List<String>>) remoteLocationIds;
    }

    /**
     * Hiring team for the job.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<JobHiringTeam>> hiringTeam() {
        return (JsonNullable<List<JobHiringTeam>>) hiringTeam;
    }

    /**
     * Interview stages for the job.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<InterviewStage>> interviewStages() {
        return (JsonNullable<List<InterviewStage>>) interviewStages;
    }

    /**
     * Confidential status of the job
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<JobConfidential> confidential() {
        return (JsonNullable<JobConfidential>) confidential;
    }

    /**
     * The job custom fields
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<CustomFields>> customFields() {
        return (JsonNullable<List<CustomFields>>) customFields;
    }

    /**
     * Date of creation
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Date of last update
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public Job withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Job withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Job withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Job withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Job withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Job withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * Code of the job
     */
    public Job withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = JsonNullable.of(code);
        return this;
    }

    /**
     * Code of the job
     */
    public Job withCode(JsonNullable<String> code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    /**
     * Title of the job
     */
    public Job withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of(title);
        return this;
    }

    /**
     * Title of the job
     */
    public Job withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * Status of the job
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Job withStatus(String status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * Status of the job
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Job withStatus(JsonNullable<String> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Status of the job
     */
    public Job withJobStatus(JobStatus jobStatus) {
        Utils.checkNotNull(jobStatus, "jobStatus");
        this.jobStatus = JsonNullable.of(jobStatus);
        return this;
    }

    /**
     * Status of the job
     */
    public Job withJobStatus(JsonNullable<? extends JobStatus> jobStatus) {
        Utils.checkNotNull(jobStatus, "jobStatus");
        this.jobStatus = jobStatus;
        return this;
    }

    /**
     * Department ids of the job
     */
    public Job withDepartmentIds(List<String> departmentIds) {
        Utils.checkNotNull(departmentIds, "departmentIds");
        this.departmentIds = JsonNullable.of(departmentIds);
        return this;
    }

    /**
     * Department ids of the job
     */
    public Job withDepartmentIds(JsonNullable<? extends List<String>> departmentIds) {
        Utils.checkNotNull(departmentIds, "departmentIds");
        this.departmentIds = departmentIds;
        return this;
    }

    /**
     * Provider's department ids of the job
     */
    public Job withRemoteDepartmentIds(List<String> remoteDepartmentIds) {
        Utils.checkNotNull(remoteDepartmentIds, "remoteDepartmentIds");
        this.remoteDepartmentIds = JsonNullable.of(remoteDepartmentIds);
        return this;
    }

    /**
     * Provider's department ids of the job
     */
    public Job withRemoteDepartmentIds(JsonNullable<? extends List<String>> remoteDepartmentIds) {
        Utils.checkNotNull(remoteDepartmentIds, "remoteDepartmentIds");
        this.remoteDepartmentIds = remoteDepartmentIds;
        return this;
    }

    /**
     * Location ids of the job
     */
    public Job withLocationIds(List<String> locationIds) {
        Utils.checkNotNull(locationIds, "locationIds");
        this.locationIds = JsonNullable.of(locationIds);
        return this;
    }

    /**
     * Location ids of the job
     */
    public Job withLocationIds(JsonNullable<? extends List<String>> locationIds) {
        Utils.checkNotNull(locationIds, "locationIds");
        this.locationIds = locationIds;
        return this;
    }

    /**
     * Provider's location ids of the job
     */
    public Job withRemoteLocationIds(List<String> remoteLocationIds) {
        Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
        this.remoteLocationIds = JsonNullable.of(remoteLocationIds);
        return this;
    }

    /**
     * Provider's location ids of the job
     */
    public Job withRemoteLocationIds(JsonNullable<? extends List<String>> remoteLocationIds) {
        Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
        this.remoteLocationIds = remoteLocationIds;
        return this;
    }

    /**
     * Hiring team for the job.
     */
    public Job withHiringTeam(List<JobHiringTeam> hiringTeam) {
        Utils.checkNotNull(hiringTeam, "hiringTeam");
        this.hiringTeam = JsonNullable.of(hiringTeam);
        return this;
    }

    /**
     * Hiring team for the job.
     */
    public Job withHiringTeam(JsonNullable<? extends List<JobHiringTeam>> hiringTeam) {
        Utils.checkNotNull(hiringTeam, "hiringTeam");
        this.hiringTeam = hiringTeam;
        return this;
    }

    /**
     * Interview stages for the job.
     */
    public Job withInterviewStages(List<InterviewStage> interviewStages) {
        Utils.checkNotNull(interviewStages, "interviewStages");
        this.interviewStages = JsonNullable.of(interviewStages);
        return this;
    }

    /**
     * Interview stages for the job.
     */
    public Job withInterviewStages(JsonNullable<? extends List<InterviewStage>> interviewStages) {
        Utils.checkNotNull(interviewStages, "interviewStages");
        this.interviewStages = interviewStages;
        return this;
    }

    /**
     * Confidential status of the job
     */
    public Job withConfidential(JobConfidential confidential) {
        Utils.checkNotNull(confidential, "confidential");
        this.confidential = JsonNullable.of(confidential);
        return this;
    }

    /**
     * Confidential status of the job
     */
    public Job withConfidential(JsonNullable<? extends JobConfidential> confidential) {
        Utils.checkNotNull(confidential, "confidential");
        this.confidential = confidential;
        return this;
    }

    /**
     * The job custom fields
     */
    public Job withCustomFields(List<CustomFields> customFields) {
        Utils.checkNotNull(customFields, "customFields");
        this.customFields = JsonNullable.of(customFields);
        return this;
    }

    /**
     * The job custom fields
     */
    public Job withCustomFields(JsonNullable<? extends List<CustomFields>> customFields) {
        Utils.checkNotNull(customFields, "customFields");
        this.customFields = customFields;
        return this;
    }

    /**
     * Date of creation
     */
    public Job withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Date of creation
     */
    public Job withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Date of last update
     */
    public Job withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Date of last update
     */
    public Job withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Job other = (Job) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Objects.deepEquals(this.code, other.code) &&
            Objects.deepEquals(this.title, other.title) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.jobStatus, other.jobStatus) &&
            Objects.deepEquals(this.departmentIds, other.departmentIds) &&
            Objects.deepEquals(this.remoteDepartmentIds, other.remoteDepartmentIds) &&
            Objects.deepEquals(this.locationIds, other.locationIds) &&
            Objects.deepEquals(this.remoteLocationIds, other.remoteLocationIds) &&
            Objects.deepEquals(this.hiringTeam, other.hiringTeam) &&
            Objects.deepEquals(this.interviewStages, other.interviewStages) &&
            Objects.deepEquals(this.confidential, other.confidential) &&
            Objects.deepEquals(this.customFields, other.customFields) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            unifiedCustomFields,
            code,
            title,
            status,
            jobStatus,
            departmentIds,
            remoteDepartmentIds,
            locationIds,
            remoteLocationIds,
            hiringTeam,
            interviewStages,
            confidential,
            customFields,
            createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Job.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "code", code,
                "title", title,
                "status", status,
                "jobStatus", jobStatus,
                "departmentIds", departmentIds,
                "remoteDepartmentIds", remoteDepartmentIds,
                "locationIds", locationIds,
                "remoteLocationIds", remoteLocationIds,
                "hiringTeam", hiringTeam,
                "interviewStages", interviewStages,
                "confidential", confidential,
                "customFields", customFields,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> code = JsonNullable.undefined();
 
        private JsonNullable<String> title = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> status = JsonNullable.undefined();
 
        private JsonNullable<? extends JobStatus> jobStatus = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> departmentIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteDepartmentIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> locationIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteLocationIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<JobHiringTeam>> hiringTeam = JsonNullable.undefined();
 
        private JsonNullable<? extends List<InterviewStage>> interviewStages = JsonNullable.undefined();
 
        private JsonNullable<? extends JobConfidential> confidential = JsonNullable.undefined();
 
        private JsonNullable<? extends List<CustomFields>> customFields = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * Code of the job
         */
        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = JsonNullable.of(code);
            return this;
        }

        /**
         * Code of the job
         */
        public Builder code(JsonNullable<String> code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        /**
         * Title of the job
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of(title);
            return this;
        }

        /**
         * Title of the job
         */
        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        /**
         * Status of the job
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder status(String status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * Status of the job
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder status(JsonNullable<String> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * Status of the job
         */
        public Builder jobStatus(JobStatus jobStatus) {
            Utils.checkNotNull(jobStatus, "jobStatus");
            this.jobStatus = JsonNullable.of(jobStatus);
            return this;
        }

        /**
         * Status of the job
         */
        public Builder jobStatus(JsonNullable<? extends JobStatus> jobStatus) {
            Utils.checkNotNull(jobStatus, "jobStatus");
            this.jobStatus = jobStatus;
            return this;
        }

        /**
         * Department ids of the job
         */
        public Builder departmentIds(List<String> departmentIds) {
            Utils.checkNotNull(departmentIds, "departmentIds");
            this.departmentIds = JsonNullable.of(departmentIds);
            return this;
        }

        /**
         * Department ids of the job
         */
        public Builder departmentIds(JsonNullable<? extends List<String>> departmentIds) {
            Utils.checkNotNull(departmentIds, "departmentIds");
            this.departmentIds = departmentIds;
            return this;
        }

        /**
         * Provider's department ids of the job
         */
        public Builder remoteDepartmentIds(List<String> remoteDepartmentIds) {
            Utils.checkNotNull(remoteDepartmentIds, "remoteDepartmentIds");
            this.remoteDepartmentIds = JsonNullable.of(remoteDepartmentIds);
            return this;
        }

        /**
         * Provider's department ids of the job
         */
        public Builder remoteDepartmentIds(JsonNullable<? extends List<String>> remoteDepartmentIds) {
            Utils.checkNotNull(remoteDepartmentIds, "remoteDepartmentIds");
            this.remoteDepartmentIds = remoteDepartmentIds;
            return this;
        }

        /**
         * Location ids of the job
         */
        public Builder locationIds(List<String> locationIds) {
            Utils.checkNotNull(locationIds, "locationIds");
            this.locationIds = JsonNullable.of(locationIds);
            return this;
        }

        /**
         * Location ids of the job
         */
        public Builder locationIds(JsonNullable<? extends List<String>> locationIds) {
            Utils.checkNotNull(locationIds, "locationIds");
            this.locationIds = locationIds;
            return this;
        }

        /**
         * Provider's location ids of the job
         */
        public Builder remoteLocationIds(List<String> remoteLocationIds) {
            Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
            this.remoteLocationIds = JsonNullable.of(remoteLocationIds);
            return this;
        }

        /**
         * Provider's location ids of the job
         */
        public Builder remoteLocationIds(JsonNullable<? extends List<String>> remoteLocationIds) {
            Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
            this.remoteLocationIds = remoteLocationIds;
            return this;
        }

        /**
         * Hiring team for the job.
         */
        public Builder hiringTeam(List<JobHiringTeam> hiringTeam) {
            Utils.checkNotNull(hiringTeam, "hiringTeam");
            this.hiringTeam = JsonNullable.of(hiringTeam);
            return this;
        }

        /**
         * Hiring team for the job.
         */
        public Builder hiringTeam(JsonNullable<? extends List<JobHiringTeam>> hiringTeam) {
            Utils.checkNotNull(hiringTeam, "hiringTeam");
            this.hiringTeam = hiringTeam;
            return this;
        }

        /**
         * Interview stages for the job.
         */
        public Builder interviewStages(List<InterviewStage> interviewStages) {
            Utils.checkNotNull(interviewStages, "interviewStages");
            this.interviewStages = JsonNullable.of(interviewStages);
            return this;
        }

        /**
         * Interview stages for the job.
         */
        public Builder interviewStages(JsonNullable<? extends List<InterviewStage>> interviewStages) {
            Utils.checkNotNull(interviewStages, "interviewStages");
            this.interviewStages = interviewStages;
            return this;
        }

        /**
         * Confidential status of the job
         */
        public Builder confidential(JobConfidential confidential) {
            Utils.checkNotNull(confidential, "confidential");
            this.confidential = JsonNullable.of(confidential);
            return this;
        }

        /**
         * Confidential status of the job
         */
        public Builder confidential(JsonNullable<? extends JobConfidential> confidential) {
            Utils.checkNotNull(confidential, "confidential");
            this.confidential = confidential;
            return this;
        }

        /**
         * The job custom fields
         */
        public Builder customFields(List<CustomFields> customFields) {
            Utils.checkNotNull(customFields, "customFields");
            this.customFields = JsonNullable.of(customFields);
            return this;
        }

        /**
         * The job custom fields
         */
        public Builder customFields(JsonNullable<? extends List<CustomFields>> customFields) {
            Utils.checkNotNull(customFields, "customFields");
            this.customFields = customFields;
            return this;
        }

        /**
         * Date of creation
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Date of creation
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Date of last update
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Date of last update
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }
        
        public Job build() {
            return new Job(
                id,
                remoteId,
                unifiedCustomFields,
                code,
                title,
                status,
                jobStatus,
                departmentIds,
                remoteDepartmentIds,
                locationIds,
                remoteLocationIds,
                hiringTeam,
                interviewStages,
                confidential,
                customFields,
                createdAt,
                updatedAt);
        }
    }
}

