/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateMessage {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * Stackone enum identifying the type of message associated with the content.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message_type")
    private JsonNullable<? extends CreateMessageMessageType> messageType;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message_content")
    private JsonNullable<? extends CreateMessageMessageContent> messageContent;

    @JsonCreator
    public CreateMessage(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("message_type") JsonNullable<? extends CreateMessageMessageType> messageType,
            @JsonProperty("message_content") JsonNullable<? extends CreateMessageMessageContent> messageContent) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(messageType, "messageType");
        Utils.checkNotNull(messageContent, "messageContent");
        this.id = id;
        this.name = name;
        this.messageType = messageType;
        this.messageContent = messageContent;
    }
    
    public CreateMessage() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Stackone enum identifying the type of message associated with the content.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateMessageMessageType> messageType() {
        return (JsonNullable<CreateMessageMessageType>) messageType;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateMessageMessageContent> messageContent() {
        return (JsonNullable<CreateMessageMessageContent>) messageContent;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public CreateMessage withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public CreateMessage withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public CreateMessage withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    public CreateMessage withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Stackone enum identifying the type of message associated with the content.
     */
    public CreateMessage withMessageType(CreateMessageMessageType messageType) {
        Utils.checkNotNull(messageType, "messageType");
        this.messageType = JsonNullable.of(messageType);
        return this;
    }

    /**
     * Stackone enum identifying the type of message associated with the content.
     */
    public CreateMessage withMessageType(JsonNullable<? extends CreateMessageMessageType> messageType) {
        Utils.checkNotNull(messageType, "messageType");
        this.messageType = messageType;
        return this;
    }

    public CreateMessage withMessageContent(CreateMessageMessageContent messageContent) {
        Utils.checkNotNull(messageContent, "messageContent");
        this.messageContent = JsonNullable.of(messageContent);
        return this;
    }

    public CreateMessage withMessageContent(JsonNullable<? extends CreateMessageMessageContent> messageContent) {
        Utils.checkNotNull(messageContent, "messageContent");
        this.messageContent = messageContent;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateMessage other = (CreateMessage) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.messageType, other.messageType) &&
            Objects.deepEquals(this.messageContent, other.messageContent);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            name,
            messageType,
            messageContent);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateMessage.class,
                "id", id,
                "name", name,
                "messageType", messageType,
                "messageContent", messageContent);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<? extends CreateMessageMessageType> messageType = JsonNullable.undefined();
 
        private JsonNullable<? extends CreateMessageMessageContent> messageContent = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * Stackone enum identifying the type of message associated with the content.
         */
        public Builder messageType(CreateMessageMessageType messageType) {
            Utils.checkNotNull(messageType, "messageType");
            this.messageType = JsonNullable.of(messageType);
            return this;
        }

        /**
         * Stackone enum identifying the type of message associated with the content.
         */
        public Builder messageType(JsonNullable<? extends CreateMessageMessageType> messageType) {
            Utils.checkNotNull(messageType, "messageType");
            this.messageType = messageType;
            return this;
        }

        public Builder messageContent(CreateMessageMessageContent messageContent) {
            Utils.checkNotNull(messageContent, "messageContent");
            this.messageContent = JsonNullable.of(messageContent);
            return this;
        }

        public Builder messageContent(JsonNullable<? extends CreateMessageMessageContent> messageContent) {
            Utils.checkNotNull(messageContent, "messageContent");
            this.messageContent = messageContent;
            return this;
        }
        
        public CreateMessage build() {
            return new CreateMessage(
                id,
                name,
                messageType,
                messageContent);
        }
    }
}

