/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.operations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class LmsDeleteUserCompletionRequest {

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;

    @JsonCreator
    public LmsDeleteUserCompletionRequest(
            String xAccountId,
            String id,
            String subResourceId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public String subResourceId() {
        return subResourceId;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The account identifier
     */
    public LmsDeleteUserCompletionRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsDeleteUserCompletionRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsDeleteUserCompletionRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsDeleteUserCompletionRequest other = (LmsDeleteUserCompletionRequest) o;
        return 
            Objects.deepEquals(this.xAccountId, other.xAccountId) &&
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.subResourceId, other.subResourceId);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xAccountId,
            id,
            subResourceId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsDeleteUserCompletionRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "subResourceId", subResourceId);
    }
    
    public final static class Builder {
 
        private String xAccountId;
 
        private String id;
 
        private String subResourceId;  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }
        
        public LmsDeleteUserCompletionRequest build() {
            return new LmsDeleteUserCompletionRequest(
                xAccountId,
                id,
                subResourceId);
        }
    }
}

