/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class BackgroundCheckResultValue {
    public static final BackgroundCheckResultValue CANCELLED = new BackgroundCheckResultValue("cancelled");
    public static final BackgroundCheckResultValue COMPLETED = new BackgroundCheckResultValue("completed");
    public static final BackgroundCheckResultValue EXPIRED = new BackgroundCheckResultValue("expired");
    public static final BackgroundCheckResultValue FAILED = new BackgroundCheckResultValue("failed");
    public static final BackgroundCheckResultValue PASSED = new BackgroundCheckResultValue("passed");
    private static final Map<String, BackgroundCheckResultValue> values = BackgroundCheckResultValue.createValuesMap();
    private static final Map<String, BackgroundCheckResultValueEnum> enums = BackgroundCheckResultValue.createEnumsMap();
    private final String value;

    private BackgroundCheckResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackgroundCheckResultValue of(String value) {
        Class<BackgroundCheckResultValue> clazz = BackgroundCheckResultValue.class;
        synchronized (BackgroundCheckResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new BackgroundCheckResultValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<BackgroundCheckResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackgroundCheckResultValue other = (BackgroundCheckResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "BackgroundCheckResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackgroundCheckResultValue[] values() {
        Class<BackgroundCheckResultValue> clazz = BackgroundCheckResultValue.class;
        synchronized (BackgroundCheckResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new BackgroundCheckResultValue[0]);
        }
    }

    private static final Map<String, BackgroundCheckResultValue> createValuesMap() {
        LinkedHashMap<String, BackgroundCheckResultValue> map = new LinkedHashMap<String, BackgroundCheckResultValue>();
        map.put("cancelled", CANCELLED);
        map.put("completed", COMPLETED);
        map.put("expired", EXPIRED);
        map.put("failed", FAILED);
        map.put("passed", PASSED);
        return map;
    }

    private static final Map<String, BackgroundCheckResultValueEnum> createEnumsMap() {
        HashMap<String, BackgroundCheckResultValueEnum> map = new HashMap<String, BackgroundCheckResultValueEnum>();
        map.put("cancelled", BackgroundCheckResultValueEnum.CANCELLED);
        map.put("completed", BackgroundCheckResultValueEnum.COMPLETED);
        map.put("expired", BackgroundCheckResultValueEnum.EXPIRED);
        map.put("failed", BackgroundCheckResultValueEnum.FAILED);
        map.put("passed", BackgroundCheckResultValueEnum.PASSED);
        return map;
    }

    public static enum BackgroundCheckResultValueEnum {
        CANCELLED("cancelled"),
        COMPLETED("completed"),
        EXPIRED("expired"),
        FAILED("failed"),
        PASSED("passed");

        private final String value;

        private BackgroundCheckResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<BackgroundCheckResultValue> {
        protected _Deserializer() {
            super(BackgroundCheckResultValue.class);
        }

        public BackgroundCheckResultValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return BackgroundCheckResultValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<BackgroundCheckResultValue> {
        protected _Serializer() {
            super(BackgroundCheckResultValue.class);
        }

        public void serialize(BackgroundCheckResultValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

