/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class HrisDownloadEmployeeDocumentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=format")
    private JsonNullable<String> format;

    @JsonCreator
    public HrisDownloadEmployeeDocumentRequest(String xAccountId, String id, String subResourceId, JsonNullable<String> format) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(format, "format");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
        this.format = format;
    }

    public HrisDownloadEmployeeDocumentRequest(String xAccountId, String id, String subResourceId) {
        this(xAccountId, id, subResourceId, (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String subResourceId() {
        return this.subResourceId;
    }

    @JsonIgnore
    public JsonNullable<String> format() {
        return this.format;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisDownloadEmployeeDocumentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisDownloadEmployeeDocumentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisDownloadEmployeeDocumentRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    public HrisDownloadEmployeeDocumentRequest withFormat(String format) {
        Utils.checkNotNull(format, "format");
        this.format = JsonNullable.of((Object)format);
        return this;
    }

    public HrisDownloadEmployeeDocumentRequest withFormat(JsonNullable<String> format) {
        Utils.checkNotNull(format, "format");
        this.format = format;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisDownloadEmployeeDocumentRequest other = (HrisDownloadEmployeeDocumentRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.subResourceId, other.subResourceId) && Objects.deepEquals(this.format, other.format);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.id, this.subResourceId, this.format);
    }

    public String toString() {
        return Utils.toString(HrisDownloadEmployeeDocumentRequest.class, "xAccountId", this.xAccountId, "id", this.id, "subResourceId", this.subResourceId, "format", this.format);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private String subResourceId;
        private JsonNullable<String> format = JsonNullable.undefined();

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }

        public Builder format(String format) {
            Utils.checkNotNull(format, "format");
            this.format = JsonNullable.of((Object)format);
            return this;
        }

        public Builder format(JsonNullable<String> format) {
            Utils.checkNotNull(format, "format");
            this.format = format;
            return this;
        }

        public HrisDownloadEmployeeDocumentRequest build() {
            return new HrisDownloadEmployeeDocumentRequest(this.xAccountId, this.id, this.subResourceId, this.format);
        }
    }
}

