/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;


public class DocumentsGetFileRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * The session token
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-stackone-api-session-token")
    private Optional<String> xStackoneApiSessionToken;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=raw")
    private JsonNullable<Boolean> raw;

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    @SpeakeasyMetadata("queryParam:style=deepObject,explode=true,name=proxy")
    private JsonNullable<? extends Map<String, Object>> proxy;

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=fields")
    private JsonNullable<String> fields;

    /**
     * The comma separated list of fields that will be included in the response
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=include")
    private JsonNullable<String> include;

    @JsonCreator
    public DocumentsGetFileRequest(
            String xAccountId,
            Optional<String> xStackoneApiSessionToken,
            String id,
            JsonNullable<Boolean> raw,
            JsonNullable<? extends Map<String, Object>> proxy,
            JsonNullable<String> fields,
            JsonNullable<String> include) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(raw, "raw");
        Utils.checkNotNull(proxy, "proxy");
        Utils.checkNotNull(fields, "fields");
        Utils.checkNotNull(include, "include");
        this.xAccountId = xAccountId;
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        this.id = id;
        this.raw = raw;
        this.proxy = proxy;
        this.fields = fields;
        this.include = include;
    }
    
    public DocumentsGetFileRequest(
            String xAccountId,
            String id) {
        this(xAccountId, Optional.empty(), id,
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * The session token
     */
    @JsonIgnore
    public Optional<String> xStackoneApiSessionToken() {
        return xStackoneApiSessionToken;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    @JsonIgnore
    public JsonNullable<Boolean> raw() {
        return raw;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> proxy() {
        return (JsonNullable<Map<String, Object>>) proxy;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    @JsonIgnore
    public JsonNullable<String> fields() {
        return fields;
    }

    /**
     * The comma separated list of fields that will be included in the response
     */
    @JsonIgnore
    public JsonNullable<String> include() {
        return include;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public DocumentsGetFileRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * The session token
     */
    public DocumentsGetFileRequest withXStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
        return this;
    }


    /**
     * The session token
     */
    public DocumentsGetFileRequest withXStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    public DocumentsGetFileRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    public DocumentsGetFileRequest withRaw(boolean raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    public DocumentsGetFileRequest withRaw(JsonNullable<Boolean> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    public DocumentsGetFileRequest withProxy(Map<String, Object> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = JsonNullable.of(proxy);
        return this;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    public DocumentsGetFileRequest withProxy(JsonNullable<? extends Map<String, Object>> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = proxy;
        return this;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    public DocumentsGetFileRequest withFields(String fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = JsonNullable.of(fields);
        return this;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    public DocumentsGetFileRequest withFields(JsonNullable<String> fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = fields;
        return this;
    }

    /**
     * The comma separated list of fields that will be included in the response
     */
    public DocumentsGetFileRequest withInclude(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of(include);
        return this;
    }

    /**
     * The comma separated list of fields that will be included in the response
     */
    public DocumentsGetFileRequest withInclude(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DocumentsGetFileRequest other = (DocumentsGetFileRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.xStackoneApiSessionToken, other.xStackoneApiSessionToken) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.raw, other.raw) &&
            Utils.enhancedDeepEquals(this.proxy, other.proxy) &&
            Utils.enhancedDeepEquals(this.fields, other.fields) &&
            Utils.enhancedDeepEquals(this.include, other.include);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, xStackoneApiSessionToken, id,
            raw, proxy, fields,
            include);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DocumentsGetFileRequest.class,
                "xAccountId", xAccountId,
                "xStackoneApiSessionToken", xStackoneApiSessionToken,
                "id", id,
                "raw", raw,
                "proxy", proxy,
                "fields", fields,
                "include", include);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> xStackoneApiSessionToken = Optional.empty();

        private String id;

        private JsonNullable<Boolean> raw = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> proxy = JsonNullable.undefined();

        private JsonNullable<String> fields = JsonNullable.undefined();

        private JsonNullable<String> include = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * The session token
         */
        public Builder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
            return this;
        }

        /**
         * The session token
         */
        public Builder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = xStackoneApiSessionToken;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
         */
        public Builder raw(boolean raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        /**
         * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
         */
        public Builder raw(JsonNullable<Boolean> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }


        /**
         * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
         */
        public Builder proxy(Map<String, Object> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = JsonNullable.of(proxy);
            return this;
        }

        /**
         * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
         */
        public Builder proxy(JsonNullable<? extends Map<String, Object>> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = proxy;
            return this;
        }


        /**
         * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
         */
        public Builder fields(String fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = JsonNullable.of(fields);
            return this;
        }

        /**
         * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
         */
        public Builder fields(JsonNullable<String> fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = fields;
            return this;
        }


        /**
         * The comma separated list of fields that will be included in the response
         */
        public Builder include(String include) {
            Utils.checkNotNull(include, "include");
            this.include = JsonNullable.of(include);
            return this;
        }

        /**
         * The comma separated list of fields that will be included in the response
         */
        public Builder include(JsonNullable<String> include) {
            Utils.checkNotNull(include, "include");
            this.include = include;
            return this;
        }

        public DocumentsGetFileRequest build() {

            return new DocumentsGetFileRequest(
                xAccountId, xStackoneApiSessionToken, id,
                raw, proxy, fields,
                include);
        }

    }
}
