/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.models.operations.DocumentsDownloadFileRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetDriveRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFileRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFolderRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListDrivesRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListFilesRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListFoldersRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsUploadFileRequest;
import com.stackone.stackone_client_java.models.operations.async.DocumentsDownloadFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsDownloadFileResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetDriveRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetDriveResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetFileResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetFolderRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetFolderResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListDrivesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListDrivesResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListFilesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListFilesResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListFoldersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListFoldersResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsUploadFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsUploadFileResponse;
import com.stackone.stackone_client_java.operations.DocumentsDownloadFile;
import com.stackone.stackone_client_java.operations.DocumentsGetDrive;
import com.stackone.stackone_client_java.operations.DocumentsGetFile;
import com.stackone.stackone_client_java.operations.DocumentsGetFolder;
import com.stackone.stackone_client_java.operations.DocumentsListDrives;
import com.stackone.stackone_client_java.operations.DocumentsListFiles;
import com.stackone.stackone_client_java.operations.DocumentsListFolders;
import com.stackone.stackone_client_java.operations.DocumentsUploadFile;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


public class AsyncDocuments {
    private final SDKConfiguration sdkConfiguration;
    private final Documents syncSDK;

    AsyncDocuments(Documents syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Documents sync() {
        return syncSDK;
    }


    /**
     * Download File
     * 
     * @return The async call builder
     */
    public DocumentsDownloadFileRequestBuilder downloadFile() {
        return new DocumentsDownloadFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Download File
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;DocumentsDownloadFileResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsDownloadFileResponse> downloadFile(DocumentsDownloadFileRequest request) {
        return downloadFile(request, Optional.empty());
    }

    /**
     * Download File
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;DocumentsDownloadFileResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsDownloadFileResponse> downloadFile(DocumentsDownloadFileRequest request, Optional<Options> options) {
        AsyncRequestOperation<DocumentsDownloadFileRequest, DocumentsDownloadFileResponse> operation
              = new DocumentsDownloadFile.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Upload File
     * 
     * @return The async call builder
     */
    public DocumentsUploadFileRequestBuilder uploadFile() {
        return new DocumentsUploadFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Upload File
     * 
     * @param xAccountId The account identifier
     * @param unifiedUploadRequestDto 
     * @return CompletableFuture&lt;DocumentsUploadFileResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsUploadFileResponse> uploadFile(String xAccountId, UnifiedUploadRequestDto unifiedUploadRequestDto) {
        return uploadFile(
                xAccountId, Optional.empty(), unifiedUploadRequestDto,
                Optional.empty());
    }

    /**
     * Upload File
     * 
     * @param xAccountId The account identifier
     * @param xStackoneApiSessionToken The session token
     * @param unifiedUploadRequestDto 
     * @param options additional options
     * @return CompletableFuture&lt;DocumentsUploadFileResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsUploadFileResponse> uploadFile(
            String xAccountId, Optional<String> xStackoneApiSessionToken,
            UnifiedUploadRequestDto unifiedUploadRequestDto, Optional<Options> options) {
        DocumentsUploadFileRequest request =
            DocumentsUploadFileRequest
                .builder()
                .xAccountId(xAccountId)
                .xStackoneApiSessionToken(xStackoneApiSessionToken)
                .unifiedUploadRequestDto(unifiedUploadRequestDto)
                .build();
        AsyncRequestOperation<DocumentsUploadFileRequest, DocumentsUploadFileResponse> operation
              = new DocumentsUploadFile.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Files
     * 
     * @return The async call builder
     */
    public DocumentsListFilesRequestBuilder listFiles() {
        return new DocumentsListFilesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Files
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;DocumentsListFilesResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsListFilesResponse> listFiles(DocumentsListFilesRequest request) {
        return listFiles(request, Optional.empty());
    }

    /**
     * List Files
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;DocumentsListFilesResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsListFilesResponse> listFiles(DocumentsListFilesRequest request, Optional<Options> options) {
        AsyncRequestOperation<DocumentsListFilesRequest, DocumentsListFilesResponse> operation
              = new DocumentsListFiles.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get File
     * 
     * @return The async call builder
     */
    public DocumentsGetFileRequestBuilder getFile() {
        return new DocumentsGetFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Get File
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;DocumentsGetFileResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsGetFileResponse> getFile(DocumentsGetFileRequest request) {
        return getFile(request, Optional.empty());
    }

    /**
     * Get File
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;DocumentsGetFileResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsGetFileResponse> getFile(DocumentsGetFileRequest request, Optional<Options> options) {
        AsyncRequestOperation<DocumentsGetFileRequest, DocumentsGetFileResponse> operation
              = new DocumentsGetFile.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Folders
     * 
     * @return The async call builder
     */
    public DocumentsListFoldersRequestBuilder listFolders() {
        return new DocumentsListFoldersRequestBuilder(sdkConfiguration);
    }

    /**
     * List Folders
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;DocumentsListFoldersResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsListFoldersResponse> listFolders(DocumentsListFoldersRequest request) {
        return listFolders(request, Optional.empty());
    }

    /**
     * List Folders
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;DocumentsListFoldersResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsListFoldersResponse> listFolders(DocumentsListFoldersRequest request, Optional<Options> options) {
        AsyncRequestOperation<DocumentsListFoldersRequest, DocumentsListFoldersResponse> operation
              = new DocumentsListFolders.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Folder
     * 
     * @return The async call builder
     */
    public DocumentsGetFolderRequestBuilder getFolder() {
        return new DocumentsGetFolderRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Folder
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;DocumentsGetFolderResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsGetFolderResponse> getFolder(DocumentsGetFolderRequest request) {
        return getFolder(request, Optional.empty());
    }

    /**
     * Get Folder
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;DocumentsGetFolderResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsGetFolderResponse> getFolder(DocumentsGetFolderRequest request, Optional<Options> options) {
        AsyncRequestOperation<DocumentsGetFolderRequest, DocumentsGetFolderResponse> operation
              = new DocumentsGetFolder.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Drives
     * 
     * @return The async call builder
     */
    public DocumentsListDrivesRequestBuilder listDrives() {
        return new DocumentsListDrivesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Drives
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;DocumentsListDrivesResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsListDrivesResponse> listDrives(DocumentsListDrivesRequest request) {
        return listDrives(request, Optional.empty());
    }

    /**
     * List Drives
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;DocumentsListDrivesResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsListDrivesResponse> listDrives(DocumentsListDrivesRequest request, Optional<Options> options) {
        AsyncRequestOperation<DocumentsListDrivesRequest, DocumentsListDrivesResponse> operation
              = new DocumentsListDrives.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Drive
     * 
     * @return The async call builder
     */
    public DocumentsGetDriveRequestBuilder getDrive() {
        return new DocumentsGetDriveRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Drive
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;DocumentsGetDriveResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsGetDriveResponse> getDrive(DocumentsGetDriveRequest request) {
        return getDrive(request, Optional.empty());
    }

    /**
     * Get Drive
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;DocumentsGetDriveResponse&gt; - The async response
     */
    public CompletableFuture<DocumentsGetDriveResponse> getDrive(DocumentsGetDriveRequest request, Optional<Options> options) {
        AsyncRequestOperation<DocumentsGetDriveRequest, DocumentsGetDriveResponse> operation
              = new DocumentsGetDrive.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
