/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingJournalCreateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class AccountingCreateCompanyJournalRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AccountingJournalCreateRequestDto accountingJournalCreateRequestDto;

    @JsonCreator
    public AccountingCreateCompanyJournalRequest(
            String xAccountId,
            String id,
            AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(accountingJournalCreateRequestDto, "accountingJournalCreateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.accountingJournalCreateRequestDto = accountingJournalCreateRequestDto;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public AccountingJournalCreateRequestDto accountingJournalCreateRequestDto() {
        return accountingJournalCreateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AccountingCreateCompanyJournalRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AccountingCreateCompanyJournalRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AccountingCreateCompanyJournalRequest withAccountingJournalCreateRequestDto(AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
        Utils.checkNotNull(accountingJournalCreateRequestDto, "accountingJournalCreateRequestDto");
        this.accountingJournalCreateRequestDto = accountingJournalCreateRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingCreateCompanyJournalRequest other = (AccountingCreateCompanyJournalRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.accountingJournalCreateRequestDto, other.accountingJournalCreateRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, accountingJournalCreateRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingCreateCompanyJournalRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "accountingJournalCreateRequestDto", accountingJournalCreateRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private AccountingJournalCreateRequestDto accountingJournalCreateRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        public Builder accountingJournalCreateRequestDto(AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
            Utils.checkNotNull(accountingJournalCreateRequestDto, "accountingJournalCreateRequestDto");
            this.accountingJournalCreateRequestDto = accountingJournalCreateRequestDto;
            return this;
        }

        public AccountingCreateCompanyJournalRequest build() {

            return new AccountingCreateCompanyJournalRequest(
                xAccountId, id, accountingJournalCreateRequestDto);
        }

    }
}
