/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public final class Multipart {
    private static final String CRLF = "\r\n";
    private static final String DASHES = "--";
    private static final Charset HDR_CS = StandardCharsets.ISO_8859_1;
    private static final Charset TXT_CS = StandardCharsets.UTF_8;
    private static final String DEFAULT_FILE_CT = "application/octet-stream";
    public static final String DEFAULT_TEXT_CT = "text/plain; charset=UTF-8";
    private final HttpRequest.BodyPublisher bodyPublisher;
    private final String boundary;

    private Multipart(HttpRequest.BodyPublisher bodyPublisher, String boundary) {
        this.bodyPublisher = bodyPublisher;
        this.boundary = boundary;
    }

    public HttpRequest.BodyPublisher bodyPublisher() {
        return this.bodyPublisher;
    }

    public String boundary() {
        return this.boundary;
    }

    public String contentType() {
        return "multipart/form-data; boundary=" + this.boundary;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String escapeQuoted(String s) {
        Objects.requireNonNull(s, "quoted string");
        StringBuilder out = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\\') {
                out.append('\\').append(c);
                continue;
            }
            if (c == '\r' || c == '\n') {
                out.append(' ');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private static String contentDispositionWithFilename(String name, String filename) {
        String encoded;
        String safeName = Multipart.escapeQuoted(name);
        String fallback = Multipart.escapeQuoted(Multipart.asAsciiFilenameFallback(filename));
        try {
            encoded = URLEncoder.encode(filename, TXT_CS).replace("+", "%20");
        }
        catch (Exception e) {
            encoded = fallback;
        }
        return "form-data; name=\"" + safeName + "\"; filename=\"" + fallback + "\"; filename*=UTF-8''" + encoded;
    }

    private static String asAsciiFilenameFallback(String filename) {
        StringBuilder sb = new StringBuilder(filename.length());
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (c >= ' ' && c <= '~' && c != '\"' && c != '\\') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static HttpRequest.BodyPublisher concat(HttpRequest.BodyPublisher ... publishers) {
        return HttpRequest.BodyPublishers.fromPublisher(ReactiveUtils.concat(List.of(publishers)));
    }

    private static HttpRequest.BodyPublisher concat(List<HttpRequest.BodyPublisher> publishers) {
        List bufferPublishers = List.copyOf(publishers);
        return HttpRequest.BodyPublishers.fromPublisher(ReactiveUtils.concat(bufferPublishers));
    }

    static final class FilePart
    implements Part {
        private final String name;
        private final String filename;
        private final String contentType;
        private final Blob blob;

        FilePart(String name, Blob blob, String filename, String contentType) {
            this.name = name;
            this.filename = filename;
            this.contentType = contentType != null ? contentType : Multipart.DEFAULT_FILE_CT;
            this.blob = blob;
        }

        @Override
        public HttpRequest.BodyPublisher toPublisher(String boundary) {
            String cd = Multipart.contentDispositionWithFilename(this.name, this.filename);
            String header = Multipart.DASHES + boundary + "\r\nContent-Disposition: " + cd + "\r\nContent-Type: " + this.contentType + "\r\n\r\n";
            HttpRequest.BodyPublisher h = HttpRequest.BodyPublishers.ofString(header, HDR_CS);
            HttpRequest.BodyPublisher c = HttpRequest.BodyPublishers.fromPublisher(this.blob.asPublisher());
            HttpRequest.BodyPublisher t = HttpRequest.BodyPublishers.ofString(Multipart.CRLF, HDR_CS);
            return Multipart.concat(h, c, t);
        }
    }

    static final class FormField
    implements Part {
        private final String name;
        private final String value;
        private final String contentType;

        FormField(String name, String value, String contentType) {
            this.name = name;
            this.value = value;
            this.contentType = contentType != null ? contentType : Multipart.DEFAULT_TEXT_CT;
        }

        @Override
        public HttpRequest.BodyPublisher toPublisher(String boundary) {
            String header = Multipart.DASHES + boundary + "\r\nContent-Disposition: form-data; name=\"" + Multipart.escapeQuoted(this.name) + "\"\r\nContent-Type: " + this.contentType + "\r\n\r\n";
            HttpRequest.BodyPublisher h = HttpRequest.BodyPublishers.ofString(header, HDR_CS);
            HttpRequest.BodyPublisher b = HttpRequest.BodyPublishers.ofString(this.value, TXT_CS);
            HttpRequest.BodyPublisher t = HttpRequest.BodyPublishers.ofString(Multipart.CRLF, HDR_CS);
            return Multipart.concat(h, b, t);
        }
    }

    static interface Part {
        public HttpRequest.BodyPublisher toPublisher(String var1);
    }

    public static final class Builder {
        private final List<Part> parts = new ArrayList<Part>();
        private final String boundary = UUID.randomUUID().toString();

        public Builder addPart(String name, String value) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(value, "value");
            this.parts.add(new FormField(name, value, Multipart.DEFAULT_TEXT_CT));
            return this;
        }

        public Builder addPart(String name, String value, String contentType) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(contentType, "contentType");
            this.parts.add(new FormField(name, value, contentType));
            return this;
        }

        public Builder addPart(String name, byte[] bytes, String filename, String contentType) {
            return this.addPart(name, Blob.from(bytes), filename, contentType);
        }

        public Builder addPart(String name, Blob blob, String filename, String contentType) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(blob, "blob");
            Utils.checkNotNull(filename, "filename");
            this.parts.add(new FilePart(name, blob, filename, Optional.ofNullable(contentType).orElse(Multipart.DEFAULT_FILE_CT)));
            return this;
        }

        public Multipart build() {
            if (this.parts.isEmpty()) {
                throw new IllegalStateException("Must have at least one part to build multipart message.");
            }
            ArrayList<HttpRequest.BodyPublisher> pubs = new ArrayList<HttpRequest.BodyPublisher>(this.parts.size() + 1);
            for (Part p : this.parts) {
                pubs.add(p.toPublisher(this.boundary));
            }
            pubs.add(HttpRequest.BodyPublishers.ofString(Multipart.DASHES + this.boundary + "--\r\n", HDR_CS));
            HttpRequest.BodyPublisher multipart = Multipart.concat(pubs);
            return new Multipart(multipart, this.boundary);
        }
    }
}

