/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ConnectorsMeta;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class StackoneGetConnectorMetaResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The connector meta information was retrieved
     */
    private Optional<? extends ConnectorsMeta> connectorsMeta;


    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneGetConnectorMetaResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends ConnectorsMeta> connectorsMeta,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(connectorsMeta, "connectorsMeta");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.connectorsMeta = connectorsMeta;
        this.headers = headers;
    }
    
    public StackoneGetConnectorMetaResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The connector meta information was retrieved
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ConnectorsMeta> connectorsMeta() {
        return (Optional<ConnectorsMeta>) connectorsMeta;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public StackoneGetConnectorMetaResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public StackoneGetConnectorMetaResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public StackoneGetConnectorMetaResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The connector meta information was retrieved
     */
    public StackoneGetConnectorMetaResponse withConnectorsMeta(ConnectorsMeta connectorsMeta) {
        Utils.checkNotNull(connectorsMeta, "connectorsMeta");
        this.connectorsMeta = Optional.ofNullable(connectorsMeta);
        return this;
    }


    /**
     * The connector meta information was retrieved
     */
    public StackoneGetConnectorMetaResponse withConnectorsMeta(Optional<? extends ConnectorsMeta> connectorsMeta) {
        Utils.checkNotNull(connectorsMeta, "connectorsMeta");
        this.connectorsMeta = connectorsMeta;
        return this;
    }

    public StackoneGetConnectorMetaResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneGetConnectorMetaResponse other = (StackoneGetConnectorMetaResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.connectorsMeta, other.connectorsMeta) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            connectorsMeta, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneGetConnectorMetaResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "connectorsMeta", connectorsMeta,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends ConnectorsMeta> connectorsMeta = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The connector meta information was retrieved
         */
        public Builder connectorsMeta(ConnectorsMeta connectorsMeta) {
            Utils.checkNotNull(connectorsMeta, "connectorsMeta");
            this.connectorsMeta = Optional.ofNullable(connectorsMeta);
            return this;
        }

        /**
         * The connector meta information was retrieved
         */
        public Builder connectorsMeta(Optional<? extends ConnectorsMeta> connectorsMeta) {
            Utils.checkNotNull(connectorsMeta, "connectorsMeta");
            this.connectorsMeta = connectorsMeta;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneGetConnectorMetaResponse build() {

            return new StackoneGetConnectorMetaResponse(
                contentType, statusCode, rawResponse,
                connectorsMeta, headers);
        }

    }
}
