/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScreeningResultWebhook;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ScreeningWebhookScreeningResultResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ScreeningResultWebhook> screeningResultWebhook;
    private Map<String, List<String>> headers;

    @JsonCreator
    public ScreeningWebhookScreeningResultResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ScreeningResultWebhook> screeningResultWebhook, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(screeningResultWebhook, "screeningResultWebhook");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.screeningResultWebhook = screeningResultWebhook;
        this.headers = headers;
    }

    public ScreeningWebhookScreeningResultResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ScreeningResultWebhook> screeningResultWebhook() {
        return this.screeningResultWebhook;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScreeningWebhookScreeningResultResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ScreeningWebhookScreeningResultResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ScreeningWebhookScreeningResultResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ScreeningWebhookScreeningResultResponse withScreeningResultWebhook(ScreeningResultWebhook screeningResultWebhook) {
        Utils.checkNotNull(screeningResultWebhook, "screeningResultWebhook");
        this.screeningResultWebhook = Optional.ofNullable(screeningResultWebhook);
        return this;
    }

    public ScreeningWebhookScreeningResultResponse withScreeningResultWebhook(Optional<? extends ScreeningResultWebhook> screeningResultWebhook) {
        Utils.checkNotNull(screeningResultWebhook, "screeningResultWebhook");
        this.screeningResultWebhook = screeningResultWebhook;
        return this;
    }

    public ScreeningWebhookScreeningResultResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningWebhookScreeningResultResponse other = (ScreeningWebhookScreeningResultResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.screeningResultWebhook, other.screeningResultWebhook) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.screeningResultWebhook, this.headers);
    }

    public String toString() {
        return Utils.toString(ScreeningWebhookScreeningResultResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "screeningResultWebhook", this.screeningResultWebhook, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ScreeningResultWebhook> screeningResultWebhook = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder screeningResultWebhook(ScreeningResultWebhook screeningResultWebhook) {
            Utils.checkNotNull(screeningResultWebhook, "screeningResultWebhook");
            this.screeningResultWebhook = Optional.ofNullable(screeningResultWebhook);
            return this;
        }

        public Builder screeningResultWebhook(Optional<? extends ScreeningResultWebhook> screeningResultWebhook) {
            Utils.checkNotNull(screeningResultWebhook, "screeningResultWebhook");
            this.screeningResultWebhook = screeningResultWebhook;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public ScreeningWebhookScreeningResultResponse build() {
            return new ScreeningWebhookScreeningResultResponse(this.contentType, this.statusCode, this.rawResponse, this.screeningResultWebhook, this.headers);
        }
    }
}

