/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.operations.Include;
import com.stackone.stackone_client_java.models.operations.StackoneGetLogRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListLogsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListPlatformLogsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListStepLogsRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetLogRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetLogResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneListLogsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListLogsResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneListPlatformLogsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListPlatformLogsResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneListStepLogsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListStepLogsResponse;
import com.stackone.stackone_client_java.operations.StackoneGetLog;
import com.stackone.stackone_client_java.operations.StackoneListLogs;
import com.stackone.stackone_client_java.operations.StackoneListPlatformLogs;
import com.stackone.stackone_client_java.operations.StackoneListStepLogs;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * API requests and response logs.
 */
public class AsyncRequestLogs {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final RequestLogs syncSDK;

    AsyncRequestLogs(RequestLogs syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public RequestLogs sync() {
        return syncSDK;
    }


    /**
     * List Step Logs
     * 
     * @return The async call builder
     */
    public StackoneListStepLogsRequestBuilder listStepLogs() {
        return new StackoneListStepLogsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Step Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<StackoneListStepLogsResponse>} - The async response
     */
    public CompletableFuture<StackoneListStepLogsResponse> listStepLogs(StackoneListStepLogsRequest request) {
        return listStepLogs(request, Optional.empty());
    }

    /**
     * List Step Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<StackoneListStepLogsResponse>} - The async response
     */
    public CompletableFuture<StackoneListStepLogsResponse> listStepLogs(StackoneListStepLogsRequest request, Optional<Options> options) {
        AsyncRequestOperation<StackoneListStepLogsRequest, StackoneListStepLogsResponse> operation
              = new StackoneListStepLogs.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Log
     * 
     * @return The async call builder
     */
    public StackoneGetLogRequestBuilder getLog() {
        return new StackoneGetLogRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Log
     * 
     * @param id 
     * @return {@code CompletableFuture<StackoneGetLogResponse>} - The async response
     */
    public CompletableFuture<StackoneGetLogResponse> getLog(String id) {
        return getLog(id, JsonNullable.undefined(), Optional.empty());
    }

    /**
     * Get Log
     * 
     * @param id 
     * @param include The include parameter allows you to include additional data in the response.
     * @param options additional options
     * @return {@code CompletableFuture<StackoneGetLogResponse>} - The async response
     */
    public CompletableFuture<StackoneGetLogResponse> getLog(
            String id, JsonNullable<? extends Include> include,
            Optional<Options> options) {
        StackoneGetLogRequest request =
            StackoneGetLogRequest
                .builder()
                .id(id)
                .include(include)
                .build();
        AsyncRequestOperation<StackoneGetLogRequest, StackoneGetLogResponse> operation
              = new StackoneGetLog.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Logs
     * 
     * @return The async call builder
     */
    public StackoneListLogsRequestBuilder listLogs() {
        return new StackoneListLogsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<StackoneListLogsResponse>} - The async response
     */
    public CompletableFuture<StackoneListLogsResponse> listLogs(StackoneListLogsRequest request) {
        return listLogs(request, Optional.empty());
    }

    /**
     * List Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<StackoneListLogsResponse>} - The async response
     */
    public CompletableFuture<StackoneListLogsResponse> listLogs(StackoneListLogsRequest request, Optional<Options> options) {
        AsyncRequestOperation<StackoneListLogsRequest, StackoneListLogsResponse> operation
              = new StackoneListLogs.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Platform Logs
     * 
     * @return The async call builder
     */
    public StackoneListPlatformLogsRequestBuilder listPlatformLogs() {
        return new StackoneListPlatformLogsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Platform Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<StackoneListPlatformLogsResponse>} - The async response
     */
    public CompletableFuture<StackoneListPlatformLogsResponse> listPlatformLogs(StackoneListPlatformLogsRequest request) {
        return listPlatformLogs(request, Optional.empty());
    }

    /**
     * List Platform Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<StackoneListPlatformLogsResponse>} - The async response
     */
    public CompletableFuture<StackoneListPlatformLogsResponse> listPlatformLogs(StackoneListPlatformLogsRequest request, Optional<Options> options) {
        AsyncRequestOperation<StackoneListPlatformLogsRequest, StackoneListPlatformLogsResponse> operation
              = new StackoneListPlatformLogs.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
