/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AccountingJournalResultValue {
    public static final AccountingJournalResultValue DRAFT = new AccountingJournalResultValue("draft");
    public static final AccountingJournalResultValue POSTED = new AccountingJournalResultValue("posted");
    public static final AccountingJournalResultValue VOID = new AccountingJournalResultValue("void");
    public static final AccountingJournalResultValue UNMAPPED_VALUE = new AccountingJournalResultValue("unmapped_value");
    private static final Map<String, AccountingJournalResultValue> values = AccountingJournalResultValue.createValuesMap();
    private static final Map<String, AccountingJournalResultValueEnum> enums = AccountingJournalResultValue.createEnumsMap();
    private final String value;

    private AccountingJournalResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingJournalResultValue of(String value) {
        Class<AccountingJournalResultValue> clazz = AccountingJournalResultValue.class;
        synchronized (AccountingJournalResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AccountingJournalResultValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AccountingJournalResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountingJournalResultValue other = (AccountingJournalResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AccountingJournalResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingJournalResultValue[] values() {
        Class<AccountingJournalResultValue> clazz = AccountingJournalResultValue.class;
        synchronized (AccountingJournalResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AccountingJournalResultValue[0]);
        }
    }

    private static final Map<String, AccountingJournalResultValue> createValuesMap() {
        LinkedHashMap<String, AccountingJournalResultValue> map = new LinkedHashMap<String, AccountingJournalResultValue>();
        map.put("draft", DRAFT);
        map.put("posted", POSTED);
        map.put("void", VOID);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingJournalResultValueEnum> createEnumsMap() {
        HashMap<String, AccountingJournalResultValueEnum> map = new HashMap<String, AccountingJournalResultValueEnum>();
        map.put("draft", AccountingJournalResultValueEnum.DRAFT);
        map.put("posted", AccountingJournalResultValueEnum.POSTED);
        map.put("void", AccountingJournalResultValueEnum.VOID);
        map.put("unmapped_value", AccountingJournalResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AccountingJournalResultValueEnum {
        DRAFT("draft"),
        POSTED("posted"),
        VOID("void"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AccountingJournalResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AccountingJournalResultValue> {
        protected _Deserializer() {
            super(AccountingJournalResultValue.class);
        }

        public AccountingJournalResultValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AccountingJournalResultValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AccountingJournalResultValue> {
        protected _Serializer() {
            super(AccountingJournalResultValue.class);
        }

        public void serialize(AccountingJournalResultValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

