/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * LmsCreateContentRequestDtoValue
 * 
 * <p>The StackOne unified content type.
 */
@JsonDeserialize(using = LmsCreateContentRequestDtoValue._Deserializer.class)
@JsonSerialize(using = LmsCreateContentRequestDtoValue._Serializer.class)
public class LmsCreateContentRequestDtoValue {

    public static final LmsCreateContentRequestDtoValue VIDEO = new LmsCreateContentRequestDtoValue("video");
    public static final LmsCreateContentRequestDtoValue QUIZ = new LmsCreateContentRequestDtoValue("quiz");
    public static final LmsCreateContentRequestDtoValue DOCUMENT = new LmsCreateContentRequestDtoValue("document");
    public static final LmsCreateContentRequestDtoValue AUDIO = new LmsCreateContentRequestDtoValue("audio");
    public static final LmsCreateContentRequestDtoValue ARTICLE = new LmsCreateContentRequestDtoValue("article");
    public static final LmsCreateContentRequestDtoValue UNMAPPED_VALUE = new LmsCreateContentRequestDtoValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, LmsCreateContentRequestDtoValue> values = createValuesMap();
    private static final Map<String, LmsCreateContentRequestDtoValueEnum> enums = createEnumsMap();

    private final String value;

    private LmsCreateContentRequestDtoValue(String value) {
        this.value = value;
    }

    /**
     * Returns a LmsCreateContentRequestDtoValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as LmsCreateContentRequestDtoValue
     */ 
    public static LmsCreateContentRequestDtoValue of(String value) {
        synchronized (LmsCreateContentRequestDtoValue.class) {
            return values.computeIfAbsent(value, v -> new LmsCreateContentRequestDtoValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<LmsCreateContentRequestDtoValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        LmsCreateContentRequestDtoValue other = (LmsCreateContentRequestDtoValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "LmsCreateContentRequestDtoValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static LmsCreateContentRequestDtoValue[] values() {
        synchronized (LmsCreateContentRequestDtoValue.class) {
            return values.values().toArray(new LmsCreateContentRequestDtoValue[] {});
        }
    }

    private static final Map<String, LmsCreateContentRequestDtoValue> createValuesMap() {
        Map<String, LmsCreateContentRequestDtoValue> map = new LinkedHashMap<>();
        map.put("video", VIDEO);
        map.put("quiz", QUIZ);
        map.put("document", DOCUMENT);
        map.put("audio", AUDIO);
        map.put("article", ARTICLE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, LmsCreateContentRequestDtoValueEnum> createEnumsMap() {
        Map<String, LmsCreateContentRequestDtoValueEnum> map = new HashMap<>();
        map.put("video", LmsCreateContentRequestDtoValueEnum.VIDEO);
        map.put("quiz", LmsCreateContentRequestDtoValueEnum.QUIZ);
        map.put("document", LmsCreateContentRequestDtoValueEnum.DOCUMENT);
        map.put("audio", LmsCreateContentRequestDtoValueEnum.AUDIO);
        map.put("article", LmsCreateContentRequestDtoValueEnum.ARTICLE);
        map.put("unmapped_value", LmsCreateContentRequestDtoValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<LmsCreateContentRequestDtoValue> {

        protected _Serializer() {
            super(LmsCreateContentRequestDtoValue.class);
        }

        @Override
        public void serialize(LmsCreateContentRequestDtoValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<LmsCreateContentRequestDtoValue> {

        protected _Deserializer() {
            super(LmsCreateContentRequestDtoValue.class);
        }

        @Override
        public LmsCreateContentRequestDtoValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return LmsCreateContentRequestDtoValue.of(v);
        }
    }
    
    public enum LmsCreateContentRequestDtoValueEnum {

        VIDEO("video"),
        QUIZ("quiz"),
        DOCUMENT("document"),
        AUDIO("audio"),
        ARTICLE("article"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private LmsCreateContentRequestDtoValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

