/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingUsersPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MessagingListUsersResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MessagingUsersPaginated> messagingUsersPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MessagingListUsersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MessagingUsersPaginated> messagingUsersPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.messagingUsersPaginated = messagingUsersPaginated;
        this.headers = headers;
    }

    public MessagingListUsersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MessagingUsersPaginated> messagingUsersPaginated() {
        return this.messagingUsersPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingListUsersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MessagingListUsersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MessagingListUsersResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MessagingListUsersResponse withMessagingUsersPaginated(MessagingUsersPaginated messagingUsersPaginated) {
        Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
        this.messagingUsersPaginated = Optional.ofNullable(messagingUsersPaginated);
        return this;
    }

    public MessagingListUsersResponse withMessagingUsersPaginated(Optional<? extends MessagingUsersPaginated> messagingUsersPaginated) {
        Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
        this.messagingUsersPaginated = messagingUsersPaginated;
        return this;
    }

    public MessagingListUsersResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingListUsersResponse other = (MessagingListUsersResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.messagingUsersPaginated, other.messagingUsersPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.messagingUsersPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MessagingListUsersResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "messagingUsersPaginated", this.messagingUsersPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MessagingUsersPaginated> messagingUsersPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder messagingUsersPaginated(MessagingUsersPaginated messagingUsersPaginated) {
            Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
            this.messagingUsersPaginated = Optional.ofNullable(messagingUsersPaginated);
            return this;
        }

        public Builder messagingUsersPaginated(Optional<? extends MessagingUsersPaginated> messagingUsersPaginated) {
            Utils.checkNotNull(messagingUsersPaginated, "messagingUsersPaginated");
            this.messagingUsersPaginated = messagingUsersPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MessagingListUsersResponse build() {
            return new MessagingListUsersResponse(this.contentType, this.statusCode, this.rawResponse, this.messagingUsersPaginated, this.headers);
        }
    }
}

