/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.CrmCreateContactRequestDto;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactResponse;
import com.stackone.stackone_client_java.models.operations.CrmGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.CrmGetContactCustomFieldDefinitionRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetContactCustomFieldDefinitionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmGetContactCustomFieldDefinitionResponse;
import com.stackone.stackone_client_java.models.operations.CrmGetContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmGetContactResponse;
import com.stackone.stackone_client_java.models.operations.CrmGetListRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetListRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmGetListResponse;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsResponse;
import com.stackone.stackone_client_java.models.operations.CrmListContactCustomFieldDefinitionsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListContactCustomFieldDefinitionsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmListContactCustomFieldDefinitionsResponse;
import com.stackone.stackone_client_java.models.operations.CrmListContactsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListContactsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmListContactsResponse;
import com.stackone.stackone_client_java.models.operations.CrmListListsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListListsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmListListsResponse;
import com.stackone.stackone_client_java.models.operations.CrmUpdateContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmUpdateContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmUpdateContactResponse;
import com.stackone.stackone_client_java.operations.CrmCreateContact;
import com.stackone.stackone_client_java.operations.CrmGetAccount;
import com.stackone.stackone_client_java.operations.CrmGetContact;
import com.stackone.stackone_client_java.operations.CrmGetContactCustomFieldDefinition;
import com.stackone.stackone_client_java.operations.CrmGetList;
import com.stackone.stackone_client_java.operations.CrmListAccounts;
import com.stackone.stackone_client_java.operations.CrmListContactCustomFieldDefinitions;
import com.stackone.stackone_client_java.operations.CrmListContacts;
import com.stackone.stackone_client_java.operations.CrmListLists;
import com.stackone.stackone_client_java.operations.CrmUpdateContact;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;


public class Crm {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncCrm asyncSDK;

    Crm(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncCrm(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncCrm async() {
        return asyncSDK;
    }

    /**
     * List Contacts
     * 
     * @return The call builder
     */
    public CrmListContactsRequestBuilder listContacts() {
        return new CrmListContactsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Contacts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmListContactsResponse listContacts(CrmListContactsRequest request) {
        return listContacts(request, Optional.empty());
    }

    /**
     * List Contacts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmListContactsResponse listContacts(CrmListContactsRequest request, Optional<Options> options) {
        RequestOperation<CrmListContactsRequest, CrmListContactsResponse> operation
              = new CrmListContacts.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create Contact
     * 
     * @return The call builder
     */
    public CrmCreateContactRequestBuilder createContact() {
        return new CrmCreateContactRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Contact
     * 
     * @param xAccountId The account identifier
     * @param crmCreateContactRequestDto 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmCreateContactResponse createContact(String xAccountId, CrmCreateContactRequestDto crmCreateContactRequestDto) {
        return createContact(xAccountId, crmCreateContactRequestDto, Optional.empty());
    }

    /**
     * Create Contact
     * 
     * @param xAccountId The account identifier
     * @param crmCreateContactRequestDto 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmCreateContactResponse createContact(
            String xAccountId, CrmCreateContactRequestDto crmCreateContactRequestDto,
            Optional<Options> options) {
        CrmCreateContactRequest request =
            CrmCreateContactRequest
                .builder()
                .xAccountId(xAccountId)
                .crmCreateContactRequestDto(crmCreateContactRequestDto)
                .build();
        RequestOperation<CrmCreateContactRequest, CrmCreateContactResponse> operation
              = new CrmCreateContact.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Contact
     * 
     * @return The call builder
     */
    public CrmGetContactRequestBuilder getContact() {
        return new CrmGetContactRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Contact
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmGetContactResponse getContact(CrmGetContactRequest request) {
        return getContact(request, Optional.empty());
    }

    /**
     * Get Contact
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmGetContactResponse getContact(CrmGetContactRequest request, Optional<Options> options) {
        RequestOperation<CrmGetContactRequest, CrmGetContactResponse> operation
              = new CrmGetContact.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Update Contact (early access)
     * 
     * @return The call builder
     */
    public CrmUpdateContactRequestBuilder updateContact() {
        return new CrmUpdateContactRequestBuilder(sdkConfiguration);
    }

    /**
     * Update Contact (early access)
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param crmCreateContactRequestDto 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmUpdateContactResponse updateContact(
            String xAccountId, String id,
            CrmCreateContactRequestDto crmCreateContactRequestDto) {
        return updateContact(xAccountId, id, crmCreateContactRequestDto,
            Optional.empty());
    }

    /**
     * Update Contact (early access)
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param crmCreateContactRequestDto 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmUpdateContactResponse updateContact(
            String xAccountId, String id,
            CrmCreateContactRequestDto crmCreateContactRequestDto, Optional<Options> options) {
        CrmUpdateContactRequest request =
            CrmUpdateContactRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .crmCreateContactRequestDto(crmCreateContactRequestDto)
                .build();
        RequestOperation<CrmUpdateContactRequest, CrmUpdateContactResponse> operation
              = new CrmUpdateContact.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Accounts
     * 
     * @return The call builder
     */
    public CrmListAccountsRequestBuilder listAccounts() {
        return new CrmListAccountsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmListAccountsResponse listAccounts(CrmListAccountsRequest request) {
        return listAccounts(request, Optional.empty());
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmListAccountsResponse listAccounts(CrmListAccountsRequest request, Optional<Options> options) {
        RequestOperation<CrmListAccountsRequest, CrmListAccountsResponse> operation
              = new CrmListAccounts.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Account
     * 
     * @return The call builder
     */
    public CrmGetAccountRequestBuilder getAccount() {
        return new CrmGetAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Account
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmGetAccountResponse getAccount(CrmGetAccountRequest request) {
        return getAccount(request, Optional.empty());
    }

    /**
     * Get Account
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmGetAccountResponse getAccount(CrmGetAccountRequest request, Optional<Options> options) {
        RequestOperation<CrmGetAccountRequest, CrmGetAccountResponse> operation
              = new CrmGetAccount.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get all Lists
     * 
     * @return The call builder
     */
    public CrmListListsRequestBuilder listLists() {
        return new CrmListListsRequestBuilder(sdkConfiguration);
    }

    /**
     * Get all Lists
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmListListsResponse listLists(CrmListListsRequest request) {
        return listLists(request, Optional.empty());
    }

    /**
     * Get all Lists
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmListListsResponse listLists(CrmListListsRequest request, Optional<Options> options) {
        RequestOperation<CrmListListsRequest, CrmListListsResponse> operation
              = new CrmListLists.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get List
     * 
     * @return The call builder
     */
    public CrmGetListRequestBuilder getList() {
        return new CrmGetListRequestBuilder(sdkConfiguration);
    }

    /**
     * Get List
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmGetListResponse getList(CrmGetListRequest request) {
        return getList(request, Optional.empty());
    }

    /**
     * Get List
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmGetListResponse getList(CrmGetListRequest request, Optional<Options> options) {
        RequestOperation<CrmGetListRequest, CrmGetListResponse> operation
              = new CrmGetList.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Contact Custom Field Definitions
     * 
     * @return The call builder
     */
    public CrmListContactCustomFieldDefinitionsRequestBuilder listContactCustomFieldDefinitions() {
        return new CrmListContactCustomFieldDefinitionsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Contact Custom Field Definitions
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmListContactCustomFieldDefinitionsResponse listContactCustomFieldDefinitions(CrmListContactCustomFieldDefinitionsRequest request) {
        return listContactCustomFieldDefinitions(request, Optional.empty());
    }

    /**
     * List Contact Custom Field Definitions
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmListContactCustomFieldDefinitionsResponse listContactCustomFieldDefinitions(CrmListContactCustomFieldDefinitionsRequest request, Optional<Options> options) {
        RequestOperation<CrmListContactCustomFieldDefinitionsRequest, CrmListContactCustomFieldDefinitionsResponse> operation
              = new CrmListContactCustomFieldDefinitions.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Contact Custom Field Definition
     * 
     * @return The call builder
     */
    public CrmGetContactCustomFieldDefinitionRequestBuilder getContactCustomFieldDefinition() {
        return new CrmGetContactCustomFieldDefinitionRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Contact Custom Field Definition
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmGetContactCustomFieldDefinitionResponse getContactCustomFieldDefinition(CrmGetContactCustomFieldDefinitionRequest request) {
        return getContactCustomFieldDefinition(request, Optional.empty());
    }

    /**
     * Get Contact Custom Field Definition
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public CrmGetContactCustomFieldDefinitionResponse getContactCustomFieldDefinition(CrmGetContactCustomFieldDefinitionRequest request, Optional<Options> options) {
        RequestOperation<CrmGetContactCustomFieldDefinitionRequest, CrmGetContactCustomFieldDefinitionResponse> operation
              = new CrmGetContactCustomFieldDefinition.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
